package com.bizvane.baison.facade.enums;

public enum ErrorEnum {

    METHOD_ERROR_INFO(-1, "method传入参与与约定不一致！","操作失败"),
    QUERY_ORDER_ERROR_INFO(-1, "调用会员查询订单接口异常！","操作失败"),
    OPEN_CARD_FAIL(-1,"操作失败","操作失败"),
    COUPON_NOT_ACTIVE(-1,"券未生效","券未生效"),
    COUPON_EXPIRED(-1,"券已过期","券已过期"),
    COUPON_STOP_USE(-1,"该券类型已停用","该券类型已停用"),
    COUPON_USED(-1,"券已核销","券已核销"),
    COUPON_NOTBELONG_MEMBER(-1,"券不属于该会员","券不属于该会员"),
    USE_CHANNEL_WRONG(-1,"该券不支持线下使用","该券不支持线下使用"),
    BELOW_MINMONEY(-1,"订单金额不满足券使用最低金额","订单金额不满足券使用最低金额"),
    MINDISCOUNT(-1,"订单中有商品折扣不满足券最低折扣限制","订单中有商品折扣不满足券最低折扣限制"),
    MIN_GOODSNUM(-1, "此优惠券不符合商品数量最低限制", "此优惠券不符合商品数量最低限制"),
    MAX_GOODSNUM(-1, "此优惠券不符合商品数量最高限制", "此优惠券不符合商品数量最高限制"),
    GOOD_LIMIT(-1,"此优惠券不能应用于此商品","此优惠券不能应用于此商品"),
    NOT_WHITE_LIST(-1,"商品不在白名单内","商品不在白名单内"),
    COUPON_CANNOT_BE_APPLIED_TO_THIS_ORDER(-1,"此优惠券不能应用于订单中的商品","此优惠券不能应用于订单中的商品"),
    COUPON_IS_NOT_ELIGIBLE_FOR_THIS_STORE(-1,"此优惠券不符合适用此门店","此优惠券不符合适用此门店"),
    MORETHAN_MAXMONEY(-1,"超出最大优惠额度","超出最大优惠额度"),
    BRANDID_NOT_SAME(-1,"券所属品牌与门店所属品牌不一致","券所属品牌与门店所属品牌不一致"),
    SUCCESS(1,"成功","成功"),
    SYSTEM_ERROR_INFO(-1, "系统异常！","操作失败");



    private Integer code;

    private String msg;

    private String info;

    ErrorEnum(Integer code, String msg,String info) {
        this.code = code;
        this.msg = msg;
        this.info = info;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getInfo() {
        return info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public static String getName(String code) {
        for (ErrorEnum type : ErrorEnum.values()) {
            if (code.equals(String.valueOf(type.getCode()))) {
                return type.getMsg();
            }
        }
        return "";
    }
}
