package com.bizvane.baison.facade.models.request;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * baison 会员查询接口
 * JSONField 映射为百胜对应字段
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class MemberRespModel {
    @ApiModelProperty(value = "会员卡号", name = "vip_code")
    @JSONField(name = "vip_code")
    private String cardNo;

    @ApiModelProperty(value = "电话号码", name = "tel")
    @JSONField(name = "tel")
    private String phone;

    @ApiModelProperty(value = "顾客名称", name = "customer_name")
    @JSONField(name = "customer_name")
    private String name;

    @ApiModelProperty(value = "渠道代码(注册渠道)", name = "org_code")
    private String org_code = "";

    @ApiModelProperty(value = "店铺代码", name = "shop_code")
    @JSONField(name = "shop_code")
    private String openCardStoreCode;

    @ApiModelProperty(value = "注册店员", name = "reg_user_code")
    @JSONField(name = "reg_user_code")
    private String openCardGuideCode;

    @ApiModelProperty(value = "性别（1：男 2：女）", name = "customer_sex")
    @JSONField(name = "customer_sex")
    private String gender;

    @ApiModelProperty(value = "顾客类型", name = "customer_type")
    private String customer_type = "";

    @ApiModelProperty(value = "顾客等级", name = "customer_level")
    @JSONField(name = "customer_level")
    private String offlineLevelCode;

    @ApiModelProperty(value = "生日", name = "birthday")
    private String birthday;

    @ApiModelProperty(value = "会员卡系列", name = "series_code")
    private String series_code;

    @ApiModelProperty(value = "会员来源(必填字段)", name = "source")
    @JSONField(name = "source")
    private String openCardScene;

    @ApiModelProperty(value = "国家", name = "country")
    private String country = "";

    @ApiModelProperty(value = "省份", name = "province")
    private String province;

    @ApiModelProperty(value = "城市", name = "city")
    private String city;

    @ApiModelProperty(value = "地区", name = "district")
    @JSONField(name = "district")
    private String county;

    @ApiModelProperty(value = "地址 百胜要求不包含省市区", name = "address")
    private String address;

    @ApiModelProperty(value = "邮件地址", name = "email")
    private String email;

    @ApiModelProperty(value = "添加时间", name = "is_add_time")
    @JSONField(name = "is_add_time")
    private Long createDate;

    @ApiModelProperty(value = "备注", name = "remark")
    private String remark;

    @ApiModelProperty(value = "当前积分", name = "integral")
    @JSONField(name = "integral")
    private Integer countIntegral;

    @ApiModelProperty(value = "累计消费金额", name = "consume_money")
    @JSONField(name = "consume_money")
    private Double consumeAmountAll;

    @ApiModelProperty(value = "累计消费次数", name = "consume_num")
    @JSONField(name = "consume_num")
    private Integer consumeNumberAll;

    @ApiModelProperty(value = "累计消费商品数量", name = "consume_goods_num")
    private Integer consume_goods_num = 0;

    @ApiModelProperty(value = "头像地址", name = "headphoto")
    private String headphoto = "";

    @ApiModelProperty(value = "发卡商店代码", name = "card_issuing_shop_code")
    private String card_issuing_shop_code;

    @ApiModelProperty(value = "储值卡是否启用", name = "prepaid_card_able")
    private Integer prepaid_card_able = 0;

    @ApiModelProperty(value = "储值卡余额", name = "left_money")
    @JSONField(name = "left_money")
    private Double balance;

    @ApiModelProperty(value = "锁定积分", name = "lock_integral")
    private Integer lock_integral = 0;

    @ApiModelProperty(value = "可用积分", name = "useable_integral")
    private Integer useable_integral;

    @ApiModelProperty(value = "累计消费积分", name = "consume_integral")
    private Integer consume_integral = 0;

    @ApiModelProperty(value = "发卡日期", name = "card_issuing_date")
    @JSONField(name = "card_issuing_date")
    private String openCardTime;

    @ApiModelProperty(value = "VIP卡状态 0-未启用 1-正常 2-停用,4-挂失,5-休眠", name = "status")
    @JSONField(name = "status")
    private Integer cardUseStatus;

    @ApiModelProperty(value = "折扣", name = "discount")
    private Integer discount = 0;

    @ApiModelProperty(value = "是否是员工", name = "is_staff")
    private Integer is_staff = 0;

    @ApiModelProperty(value = "剩余员工可用折扣金额", name = "staff_discount_money")
    private Float staff_discount_money = 0f;
}
