package com.bizvane.baison.facade.models.request;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotEmpty;
import java.sql.Timestamp;
import java.util.Date;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class MemberReqModel {

    @ApiModelProperty(value = "会员卡号", name = "vip_code")
    @JSONField(name = "vip_code")
    private String cardNo;

    @ApiModelProperty(value = "电话号码", name = "tel")
    @JSONField(name = "phone")
    private String phone;

    @ApiModelProperty(value = "顾客名称", name = "customer_name")
    @JSONField(name = "vip_name")
    private String name;

    @ApiModelProperty(value = "渠道代码(注册渠道) 百胜需要:多品牌 卡适用范围", name = "org_code")
    private String org_code;

    @ApiModelProperty(value = "店铺代码", name = "shop_code")
    @JSONField(name = "shop_code")
    private String openCardStoreCode;

    @ApiModelProperty(value = "注册店员", name = "assistant_code")
    @JSONField(name = "assistant_code")
    private String openCardGuideCode;

    @ApiModelProperty(value = "性别（1：女 2：男）", name = "customer_sex")
    @JSONField(name = "customer_sex")
    private String gender;

    @ApiModelProperty(value = "顾客类型", name = "customer_type")
    private String customer_type;

    @ApiModelProperty(value = "顾客等级Code", name = "level_code")
    @JSONField(name = "level_code")
    @NotEmpty
    private String offlineLevelCode;

    @ApiModelProperty(value = "生日", name = "birthday")
    private Date birthday;

    @ApiModelProperty(value = "理解为品牌code", name = "series_code")
    private String series_code;

    @ApiModelProperty(value = "国家", name = "country")
    private String country;

    @ApiModelProperty(value = "省份", name = "province")
    private String province;

    @ApiModelProperty(value = "城市", name = "city")
    private String city;

    @ApiModelProperty(value = "地区", name = "district")
    @JSONField(name = "district")
    private String county;

    @ApiModelProperty(value = "地址 百胜要求不包含省市区", name = "address")
    private String address;

    @ApiModelProperty(value = "邮件地址", name = "email")
    private String email;

    @ApiModelProperty(value = "添加时间", name = "is_add_time")
    @JSONField(name = "is_add_time")
    private Long createTime;

    @ApiModelProperty(value = "备注", name = "remark")
    private String remark;

    @ApiModelProperty(value = "qq", name = "qq")
    private Integer qq;

    @ApiModelProperty(value = "体型", name = "shape")
    private String shape;

    @ApiModelProperty(value = "衣码", name = "clothe_size")
    private String clothe_size;

    @ApiModelProperty(value = "裤码", name = "trouser_size")
    private String trouser_size;

    @ApiModelProperty(value = "鞋码", name = "shoes_size")
    private String shoes_size;

    @ApiModelProperty(value = "体重", name = "weight")
    private String weight;

    @ApiModelProperty(value = "职业", name = "job")
    private String job;

    @ApiModelProperty(value = "教育", name = "education")
    private String education;

    @ApiModelProperty(value = "品牌code", name = "brand_code")
    @JSONField(name = "brand_code")
    @NotEmpty
    private String offlineBrandCode;

    @ApiModelProperty(value = "会员注册渠道 : 1.POS(门店) 2.官网3.商城 4.微信 5.天猫 6.其他 百胜默认传1", name = "registerType")
    private Integer registerType;

    @ApiModelProperty(value = "会员可用积分 新增会员才传" , name = "points")
    @JSONField(name = "points")
    private Integer points;

    @ApiModelProperty(value = "品牌id" , name = "sysBrandId")
    private Long sysBrandId;
}
