package com.bizvane.baison.facade.models.request;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author kitandrew
 * @version 1.0.0
 * @ClassName CouponQueryRespModel.java
 * @Description TODO
 * @createTime 2020年02月20日 09:49:00
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CouponQueryRespModel {

    private Integer status;

    @ApiModelProperty(name = "type", value = "couponType （券类型 1现金，2折扣）")
    private Integer type;

    @ApiModelProperty(name = "money", value = "券面额")
    private Float money;

    @ApiModelProperty(name = "rebate", value = "券折扣")
    @JSONField(name = "rebate")
    private Double discount;

    @ApiModelProperty(name = "money_small", value = "minMoney 最低适用金额")
    private Float money_small;

    @ApiModelProperty(name = "application_nums",value = "couponSize 适用券张数,1:不限制,2:限制")
    private Integer application_nums;

    @ApiModelProperty(name = "application_numbers",value = "couponSizeNum （不限制则返回0,否则返回具体限制数值）")
    private Integer application_numbers;

    @ApiModelProperty(name = "application_per_full_money",value = "消费每满设置的金额  可以返回（需要加字段）")
    private Float application_per_full_money;

    @ApiModelProperty(name = "goods_ok_tarray" , value = "goodsSKUCodes ：适用商品SKUcode,多个逗号隔开,例如:{“goodsCode”:”skuCode”,”goodsCode1”:”skuCode1” }")
    private List<GoodModel> goods_ok;


    private List<GoodModel> goods_no;

    @ApiModelProperty(name = "integral_double" , value = "积分倍率")
    private Float integral_double;

    @ApiModelProperty(name = "money_sale", value = "销售金额")
    private Float money_sale;

    @ApiModelProperty(name = "gift_ok",value = "适用礼品")
    private List<String> gift_ok;

    @ApiModelProperty(name = "gift_num" ,value = "礼品限制数量")
    private Integer gift_num;

    @ApiModelProperty(name = "double_discount_state" ,value = "单品折扣券折上折设置")
    private Float double_discount_state;

    @ApiModelProperty(name = "use_good_num" , value = "使用商品限制数量(当type==7)")
    private Integer use_good_num;

    @ApiModelProperty(name = "max_discount_money" , value = "最大优惠金额")
    private BigDecimal max_discount_money;

}
