package com.bizvane.baison.facade.enums;


/**
 * 百胜积分类型对照商帆积分类型转换枚举
 * 解决历史对接的bug
 */
public enum BizvaneBaisonBusinessTypeEnum {
    INIT("0", "113", "初始建档"),
    CONSUME("1", "101", "消费"),
    OPERATE("5", "114", "积分调整"),
    CLEAR("7", "108", "积分清零"),
    RECHARGE("10", "115", "充值积分"),
    OTHER("", "110", "其他");


    /**
     * 百胜code
     */
    private String baisonCode;
    /**
     * 商帆code
     */
    private String bizvaneCode;

    /**
     * 描述
     */
    private String msg;

    BizvaneBaisonBusinessTypeEnum(String baisonCode, String bizvaneCode, String msg) {
        this.baisonCode = baisonCode;
        this.bizvaneCode = bizvaneCode;
        this.msg = msg;
    }

    public String getBaisonCode() {
        return baisonCode;
    }

    public String getBizvaneCode() {
        return bizvaneCode;
    }

    public String getMsg() {
        return msg;
    }

    public static BizvaneBaisonBusinessTypeEnum getBizvaneBusinessTypeByBaisonCode(String baisonCode) {
        for (BizvaneBaisonBusinessTypeEnum bizvaneBaisonBusinessTypeEnum : BizvaneBaisonBusinessTypeEnum.values()) {
            if (bizvaneBaisonBusinessTypeEnum.getBaisonCode().equals(baisonCode)) {
                return bizvaneBaisonBusinessTypeEnum;
            }
        }
        return OTHER;
    }
}
