package com.bizvane.baison.facade.base;

import com.bizvane.baison.facade.enums.ErrorEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 *
 * @param <T>
 * baison 返回body
 */
@Data
@ToString
@EqualsAndHashCode
public class ResponseBaisonData<T> {

    private int status;
    private String message;
    private T data;


    public ResponseBaisonData(T data) {
        this.status = ErrorEnum.SUCCESS.getCode();
        this.message = ErrorEnum.SUCCESS.getMsg();
        this.data = data;
    }

    public ResponseBaisonData() {
        this.status = ErrorEnum.SUCCESS.getCode();
        this.message = ErrorEnum.SUCCESS.getMsg();
    }


    public ResponseBaisonData(int status, String message, T data) {
        this.status = ErrorEnum.SUCCESS.getCode();
        this.message = ErrorEnum.SUCCESS.getMsg();
        this.status = status;
        this.data = data;
        this.message = message;
    }

    public ResponseBaisonData(int status, T data) {
        this.status = ErrorEnum.SUCCESS.getCode();
        this.message = ErrorEnum.SUCCESS.getMsg();
        this.status = status;
        this.data = data;
    }

    public ResponseBaisonData(String message, T data) {
        this.status = ErrorEnum.SUCCESS.getCode();
        this.message = ErrorEnum.SUCCESS.getMsg();
        this.data = data;
        this.message = message;
    }
}
