package com.bizvane.baisonBase.facade.models;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

/**
 * @author kitandrew
 * @version 1.0.0
 * @ClassName BaisonReqBaseModel.java
 * @Description 百胜接口请求basemodel
 * @createTime 2020年02月17日 17:15:00
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class BaisonReqBaseModel<T> implements Serializable {

    @JSONField(ordinal = 0)
    private String method;

    @JSONField(ordinal = 1)
    private Long time;

    @JSONField(ordinal = 2)
    private T params;

    @JSONField(ordinal = 3)
    private String key;

    @JSONField(ordinal = 4)
    private String sign;
}
