/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.service.metadata.impl;

import com.bizvane.audience.bo.CompanyTenantMappinBO;
import com.bizvane.audience.common.constant.TableNameConstants;
import com.bizvane.audience.common.util.BeanConvertUtils;
import com.bizvane.audience.common.util.ConvertUtils;
import com.bizvane.audience.entity.metadata.CompanyTenantMappinEntity;
import com.bizvane.audience.entity.metadata.MetadataUploadLogEntity;
import com.bizvane.audience.enums.UploadStatusEnum;
import com.bizvane.audience.mapper.metadata.CompanyTenantMappingMapper;
import com.bizvane.audience.mapper.metadata.MetadataUploadLogMapper;
import com.bizvane.audience.service.metadata.CompanyTenantMappinService;
import java.sql.Timestamp;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CompanyTenantMappinServiceImpl
implements CompanyTenantMappinService {
    private static final Logger log = LoggerFactory.getLogger(CompanyTenantMappinServiceImpl.class);
    @Resource
    private CompanyTenantMappingMapper companyTenantMappingMapper;
    @Resource
    private MetadataUploadLogMapper metadataUploadLogMapper;

    @Override
    public List<CompanyTenantMappinBO> getTenantList() {
        List companyTenantMappinEntities = this.companyTenantMappingMapper.selectTenantList();
        List companyTenantMappinBOList = ConvertUtils.listVoStream((List)companyTenantMappinEntities, CompanyTenantMappinBO.class);
        return companyTenantMappinBOList;
    }

    @Override
    public Boolean uploadOssStatus(String id, Integer status) {
        log.info("uploadOssStatus id:{},status:{}", (Object)id, (Object)status);
        MetadataUploadLogEntity record = new MetadataUploadLogEntity();
        if (TableNameConstants.UPLOAD_ERROR.equals(status)) {
            record.setUploadStatus(UploadStatusEnum.UPLOAD_SUCCESS.getCode());
        } else if (TableNameConstants.UPLOAD_OK.equals(status)) {
            record.setUploadStatus(UploadStatusEnum.UPLOAD_FAIL.getCode());
        }
        record.setModifiedDate(new Timestamp(System.currentTimeMillis()));
        record.setId(Long.valueOf(Long.parseLong(id)));
        this.metadataUploadLogMapper.updateByPrimaryKeySelective(record);
        return true;
    }

    @Override
    public CompanyTenantMappinBO getTenantOssRegion(String tenantId) {
        CompanyTenantMappinEntity companyTenantMappinEntity = this.companyTenantMappingMapper.selectByTenantId(tenantId);
        return (CompanyTenantMappinBO)BeanConvertUtils.convert((Object)companyTenantMappinEntity, CompanyTenantMappinBO.class);
    }
}

