/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.service.crypto.impl;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.audience.common.crypto.CryptoConfig;
import com.bizvane.audience.common.crypto.CryptoUtil;
import com.bizvane.audience.common.util.ResponseData;
import com.bizvane.audience.common.util.SysResponseEnum;
import com.bizvane.audience.entity.metadata.CompanyTenantMappinEntity;
import com.bizvane.audience.mapper.metadata.CompanyTenantMappingMapper;
import com.bizvane.audience.service.aliyuncs.QaComponent;
import com.bizvane.audience.service.crypto.CryptoService;
import com.bizvane.audience.vo.TokenPayLoadVo;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CryptoServiceImpl
implements CryptoService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CryptoConfig cryptoConfig;
    @Resource
    private CompanyTenantMappingMapper companyTenantMappingMapper;
    @Resource
    private QaComponent qaComponent;

    @Override
    public ResponseData<TokenPayLoadVo> decryptToken(String token) {
        this.logger.info("token:{},secret:{}", (Object)token, (Object)this.cryptoConfig.getSecret());
        ResponseData responseData = new ResponseData();
        String decrypt = CryptoUtil.decrypt((String)token, (String)this.cryptoConfig.getSecret());
        if (StringUtils.isNotBlank((CharSequence)decrypt)) {
            TokenPayLoadVo tokenPayLoadVo = (TokenPayLoadVo)JSONObject.parseObject((String)decrypt, TokenPayLoadVo.class);
            CompanyTenantMappinEntity entity = this.companyTenantMappingMapper.selectByTenantId(tokenPayLoadVo.getAud());
            if (entity != null) {
                tokenPayLoadVo.setSysCompanyId(entity.getSysCompanyId());
                tokenPayLoadVo.setSysBrandId(entity.getSysBrandId());
                this.companyTenantMappingMapper.updateOssRegionByTenantId(tokenPayLoadVo.getDbRegion(), tokenPayLoadVo.getAud());
            }
            tokenPayLoadVo.setMenuItem(this.qaComponent.getMenuItem(tokenPayLoadVo.getAud(), tokenPayLoadVo.getRoleSign()));
            responseData.setData((Object)tokenPayLoadVo);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            return responseData;
        }
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage("\u89e3\u5bc6\u5931\u8d25");
        return responseData;
    }
}

