/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.service.audience.impl;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.bizvane.audience.entity.audience.AudienceDownloadEntity;
import com.bizvane.audience.entity.audience.AudienceDownloadParticularsEntity;
import com.bizvane.audience.mapper.audience.AudienceDownloadParticularsMapper;
import com.bizvane.audience.service.audience.DownloadService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DownloadServiceImpl
implements DownloadService {
    private static final Logger log = LoggerFactory.getLogger(DownloadServiceImpl.class);
    @Resource
    RocketMQTemplate mqTemplate;
    @Resource
    private AudienceDownloadParticularsMapper audienceDownloadParticularsMapper;

    @Override
    public Boolean analysisFile(AudienceDownloadEntity audienceDownloadEntity, String path) {
        AudienceDownloadParticularsEntity audienceDownloadParticularsEntity = new AudienceDownloadParticularsEntity();
        audienceDownloadParticularsEntity.setFilePath(path);
        audienceDownloadParticularsEntity.setSysCompanyId(audienceDownloadEntity.getSysCompanyId());
        audienceDownloadParticularsEntity.setSysBrandId(audienceDownloadEntity.getSysBrandId());
        audienceDownloadParticularsEntity.setSerialNumber(audienceDownloadEntity.getSerialNumber());
        this.audienceDownloadParticularsMapper.insert(audienceDownloadParticularsEntity);
        try {
            String line;
            File file = new File(path);
            BufferedReader br = new BufferedReader(new FileReader(file));
            Destination destination = new Destination();
            destination.setTopic("qa_audiences_member_code");
            while ((line = br.readLine()) != null) {
                audienceDownloadEntity.setMemberCode(line.substring(0, line.indexOf(",")));
                this.mqTemplate.send(destination, (Object)audienceDownloadEntity);
            }
        }
        catch (Exception e) {
            log.info("this file is not analysis filepath:{}", (Object)path);
        }
        return Boolean.TRUE;
    }
}

