/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.service.audience.impl;

import com.bizvane.audience.bo.AudienceBO;
import com.bizvane.audience.common.constant.AudienceStatus;
import com.bizvane.audience.common.util.ConvertUtils;
import com.bizvane.audience.entity.audience.AudienceDownloadEntity;
import com.bizvane.audience.entity.audience.AudienceDownloadLogEntity;
import com.bizvane.audience.mapper.audience.AudienceDownloadLogMapper;
import com.bizvane.audience.mapper.audience.AudienceDownloadMapper;
import com.bizvane.audience.mapper.audience.AudienceMapper;
import com.bizvane.audience.service.audience.AudienceService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AudienceServiceImpl
implements AudienceService {
    @Resource
    private AudienceMapper audienceMapper;
    @Resource
    private AudienceDownloadMapper audienceDownloadMapper;
    @Resource
    private AudienceDownloadLogMapper audienceDownloadLogMapper;

    @Override
    public Long getAudienceCount(String audienceId) {
        return this.audienceMapper.selectAudienceCount(audienceId);
    }

    @Override
    public List<AudienceBO> getAudienceList(String audienceId, Integer limit, Integer to) {
        List audienceEntities = this.audienceMapper.selectAudienceByAudienceId(audienceId, limit, to);
        List audienceBOList = ConvertUtils.listVoStream((List)audienceEntities, AudienceBO.class);
        return audienceBOList;
    }

    @Override
    public Boolean deleteAudience(AudienceDownloadEntity audienceDownloadEntity) {
        this.audienceMapper.deleteByVersionAndAudienceId(audienceDownloadEntity.getVersion(), audienceDownloadEntity.getAudienceId());
        audienceDownloadEntity.setDataStatus(AudienceStatus.ANALYSIS_OK);
        this.audienceDownloadMapper.updateBySerialNumberSelective(audienceDownloadEntity);
        AudienceDownloadLogEntity audienceDownloadLogEntity = new AudienceDownloadLogEntity();
        audienceDownloadLogEntity.setConsumeCount(Integer.valueOf(0));
        audienceDownloadLogEntity.setSerialNumber(audienceDownloadEntity.getSerialNumber());
        this.audienceDownloadLogMapper.updateBySerialNumberSelective(audienceDownloadLogEntity);
        this.audienceMapper.deleteByPrimaryKey(audienceDownloadEntity.getVersion(), audienceDownloadEntity.getAudienceId());
        return Boolean.TRUE;
    }
}

