/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.service.aliyuncs;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.retailadvqa_public.client.QATestAcsClient;
import com.aliyuncs.retailadvqa_public.model.v20200515.ListMenuRequest;
import com.aliyuncs.retailadvqa_public.model.v20200515.ListMenuResponse;
import com.bizvane.audience.service.aliyuncs.OssConfigDelegate;
import com.bizvane.audience.vo.MenuItemVO;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QaComponent {
    private static final Logger log = LoggerFactory.getLogger(QaComponent.class);
    @Autowired
    private OssConfigDelegate ossConfigDelegate;
    static QATestAcsClient client = new QATestAcsClient();

    private static AcsResponse invoke(AcsRequest request) {
        try {
            return client.getAcsResponse(request);
        }
        catch (ClientException e) {
            log.error("ClientException", (Throwable)e);
            return null;
        }
    }

    public List<MenuItemVO> getMenuItem(String tenantId, String roleSign) {
        ListMenuRequest request = new ListMenuRequest();
        request.setAccessId(this.ossConfigDelegate.getAccessId());
        request.setTenantId(tenantId);
        request.setRoleSign(roleSign);
        ListMenuResponse response = (ListMenuResponse)QaComponent.invoke((AcsRequest)request);
        if (!response.getSuccess().booleanValue()) {
            return null;
        }
        return response.getData().stream().map(dataItem -> {
            MenuItemVO item = new MenuItemVO();
            item.setKey(dataItem.getKey());
            item.setName(dataItem.getName());
            item.setUrl(dataItem.getUrl());
            return item;
        }).collect(Collectors.toList());
    }
}

