/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.service.aliyuncs;

import com.bizvane.audience.bo.CompanyTenantMappinBO;
import com.bizvane.audience.bo.OssRegionBO;
import com.bizvane.audience.service.metadata.CompanyTenantMappinService;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class OssConfigDelegate {
    @Value(value="${aliyun.oss.accessKeyId}")
    private String accessKeyId;
    @Value(value="${aliyun.oss.accessKeySecret}")
    private String accessKeySecret;
    @Value(value="${aliyun.oss.bucketName}")
    private String testBucketName;
    @Value(value="${aliyun.oem.code}")
    private String oemCode;
    @Value(value="${aliyun.oss.accessId}")
    private String accessId;
    @Autowired
    private CompanyTenantMappinService companyTenantMappinService;
    @Autowired
    private Environment environment;
    private static Map<String, String> ossRegionMap = new HashMap<String, String>();

    @PostConstruct
    public void init() {
        ossRegionMap.put("cn-beijing", "qa-".concat(this.oemCode).concat("-cn-beijing"));
        ossRegionMap.put("cn-hangzhou", "qa-".concat(this.oemCode).concat("-cn-hangzhou"));
        ossRegionMap.put("cn-shanghai", "qa-".concat(this.oemCode).concat("-cn-shanghai"));
        ossRegionMap.put("cn-qingdao", "qa-".concat(this.oemCode).concat("-cn-qingdao"));
        ossRegionMap.put("cn-zhangjiakou", "qa-".concat(this.oemCode).concat("-cn-zhangjiakou"));
        ossRegionMap.put("cn-huhehaote", "qa-".concat(this.oemCode).concat("-cnhuhehaote"));
        ossRegionMap.put("cn-shenzhen", "qa-".concat(this.oemCode).concat("-cn-shenzhen"));
        ossRegionMap.put("cn-chengdu", "qa-".concat(this.oemCode).concat("-cn-chengdu"));
        ossRegionMap.put("cn-hongkong", "qa-".concat(this.oemCode).concat("-cn-hongkong"));
        ossRegionMap.put("ap-southeast-1", "qa-".concat(this.oemCode).concat("-ap-southeast-1"));
        ossRegionMap.put("ap-southeast-2", "qa-".concat(this.oemCode).concat("-a16p-southeast-2"));
        ossRegionMap.put("ap-southeast-3", "qa-".concat(this.oemCode).concat("-ap-southeast-3"));
        ossRegionMap.put("ap-southeast-5", "qa-".concat(this.oemCode).concat("-ap-southeast-5"));
        ossRegionMap.put("ap-northeast-1", "qa-".concat(this.oemCode).concat("-ap-northeast-1"));
        ossRegionMap.put("ap-south-1", "qa-".concat(this.oemCode).concat("-ap-south-1"));
        ossRegionMap.put("eu-central-1", "qa-".concat(this.oemCode).concat("-eucentral-1"));
        ossRegionMap.put("eu-west-1", "qa-".concat(this.oemCode).concat("-eu-west-1"));
        ossRegionMap.put("us-west-1", "qa-".concat(this.oemCode).concat("-us-west-1"));
        ossRegionMap.put("us-east-1", "qa-".concat(this.oemCode).concat("-us-east-1"));
    }

    private String getBucketNameByOssRegion(String ossRegion) {
        return ossRegionMap.get(ossRegion);
    }

    public OssRegionBO getOssRegion(String tenantId) {
        CompanyTenantMappinBO companyTenantMappinBO = this.companyTenantMappinService.getTenantOssRegion(tenantId);
        String bucketName = this.testBucketName;
        if (this.environment.acceptsProfiles(new String[]{"prod"})) {
            bucketName = this.getBucketNameByOssRegion(companyTenantMappinBO.getOssRegion());
        }
        String endpoint = String.format("http://oss-%s.aliyuncs.com", companyTenantMappinBO.getOssRegion());
        OssRegionBO ossRegionBO = new OssRegionBO();
        ossRegionBO.setBucketName(bucketName);
        ossRegionBO.setEndpoint(endpoint);
        return ossRegionBO;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public String getAccessId() {
        return this.accessId;
    }
}

