/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.service;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.UploadFileRequest;
import com.aliyun.oss.model.UploadFileResult;
import com.bizvane.audience.bo.OssRegionBO;
import com.bizvane.audience.common.constant.TableNameConstants;
import com.bizvane.audience.service.aliyuncs.OssConfigDelegate;
import com.bizvane.audience.service.metadata.CompanyTenantMappinService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UploadFileService {
    private static final Logger log = LoggerFactory.getLogger(UploadFileService.class);
    public static final long PARTSIZE = 0x100000L;
    public static final String CONTENTTYPE = "text/plain";
    @Autowired
    private CompanyTenantMappinService companyTenantMappinService;
    @Autowired
    private OssConfigDelegate ossConfigDelegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFile(String tenantId, String filePath, String fileName, String ossPath, String id) throws Throwable {
        OssRegionBO ossRegionBO = this.ossConfigDelegate.getOssRegion(tenantId);
        log.info("accessKeyId:{},accessKeySecret:{},ossRegionBO:{}", new Object[]{this.ossConfigDelegate.getAccessKeyId(), this.ossConfigDelegate.getAccessKeySecret(), JSONObject.toJSONString((Object)ossRegionBO)});
        OSS ossClient = new OSSClientBuilder().build(ossRegionBO.getEndpoint(), this.ossConfigDelegate.getAccessKeyId(), this.ossConfigDelegate.getAccessKeySecret());
        StringBuilder fullOssPath = new StringBuilder(ossPath);
        fullOssPath.append(fileName);
        UploadFileRequest uploadFileRequest = new UploadFileRequest(ossRegionBO.getBucketName(), fullOssPath.toString());
        try {
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(CONTENTTYPE);
            uploadFileRequest.setUploadFile(filePath);
            uploadFileRequest.setTaskNum(10);
            uploadFileRequest.setPartSize(0x100000L);
            uploadFileRequest.setEnableCheckpoint(true);
            UploadFileResult uploadResult = ossClient.uploadFile(uploadFileRequest);
            CompleteMultipartUploadResult multipartUploadResult = uploadResult.getMultipartUploadResult();
            fullOssPath.setLength(0);
            fullOssPath.append(ossRegionBO.getEndpoint());
            fullOssPath.append(multipartUploadResult.getKey());
            uploadFileRequest.setObjectMetadata(meta);
        }
        catch (OSSException oe) {
            log.error("UploadFileUtil OSSException Error Message:{} Request ID:{} Host ID:{}", new Object[]{oe.getErrorMessage(), oe.getRequestId(), oe.getHostId()});
        }
        catch (ClientException ce) {
            ossClient.uploadFile(uploadFileRequest);
            log.error("UploadFileUtil ClientException Error Message:{}", (Object)ce.getMessage());
        }
        catch (Throwable e) {
            this.companyTenantMappinService.uploadOssStatus(id, TableNameConstants.UPLOAD_ERROR);
            e.printStackTrace();
        }
        finally {
            ossClient.shutdown();
            this.companyTenantMappinService.uploadOssStatus(id, TableNameConstants.UPLOAD_OK);
        }
        return fullOssPath.toString();
    }
}

