/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.audience.service.audience.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.retailadvqa_public.client.QATestAcsClient;
import com.aliyuncs.retailadvqa_public.model.v20200515.ListAudiencesRequest;
import com.aliyuncs.retailadvqa_public.model.v20200515.ListAudiencesResponse;
import com.bizvane.audience.bo.AudienceDownloadBO;
import com.bizvane.audience.bo.AudienceDownloadLogBO;
import com.bizvane.audience.bo.AudienceLabelTypeBO;
import com.bizvane.audience.bo.CompanyTenantMappinBO;
import com.bizvane.audience.common.constant.AudienceStatus;
import com.bizvane.audience.common.constant.Separator;
import com.bizvane.audience.common.redis.RedisKeyUtils;
import com.bizvane.audience.common.util.BeanConvertUtils;
import com.bizvane.audience.common.util.SnowflakeIdWorker;
import com.bizvane.audience.entity.audience.AudienceDownloadEntity;
import com.bizvane.audience.entity.audience.AudienceDownloadLogEntity;
import com.bizvane.audience.entity.audience.AudienceLabelTypeEntity;
import com.bizvane.audience.entity.group.MbrGroupDefEntity;
import com.bizvane.audience.entity.group.MbrGroupTypeDefEntity;
import com.bizvane.audience.exception.AudienceErrorCode;
import com.bizvane.audience.exception.AudienceException;
import com.bizvane.audience.mapper.audience.AudienceDownloadLogMapper;
import com.bizvane.audience.mapper.audience.AudienceDownloadMapper;
import com.bizvane.audience.mapper.audience.AudienceLabelTypeMapper;
import com.bizvane.audience.mapper.audience.AudienceMapper;
import com.bizvane.audience.mapper.group.MbrGroupDefMapper;
import com.bizvane.audience.mapper.group.MbrGroupTypeDefMapper;
import com.bizvane.audience.service.audience.SearchService;
import com.bizvane.audience.service.metadata.CompanyTenantMappinService;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SearchServiceImpl
implements SearchService {
    private static final Logger log = LoggerFactory.getLogger(SearchServiceImpl.class);
    private static final String PAGE_SIZE = "1000";
    private static final String CONDITIONS_JSON = "qa";
    @Autowired
    private CompanyTenantMappinService companyTenantMappinService;
    @Resource
    private AudienceDownloadMapper audienceDownloadMapper;
    @Resource
    private AudienceDownloadLogMapper audienceDownloadLogMapper;
    @Resource
    private AudienceLabelTypeMapper audienceLabelTypeMapper;
    @Resource
    private MbrGroupDefMapper mbrGroupDefMapper;
    @Resource
    private MbrGroupTypeDefMapper mbrGroupTypeDefMapper;
    @Value(value="${aliyun.oss.accessId}")
    private String accessId;
    @Resource
    private AudienceMapper audienceMapper;
    @Resource
    private RedisTemplate<String, String> redisTemplate;
    @Resource
    SnowflakeIdWorker idWorker;

    @Override
    public ListAudiencesResponse getAudienchList(String tenantId, Integer pageNum) {
        tenantId = "bea3937b-1ff5-4aab-9a6a-f90514a0f584";
        try {
            QATestAcsClient client = new QATestAcsClient();
            ListAudiencesRequest request = new ListAudiencesRequest();
            request.setPageNum(pageNum.toString());
            request.setPageSize(PAGE_SIZE);
            request.setAccessId(this.accessId);
            request.setTenantId(tenantId);
            ListAudiencesResponse response = (ListAudiencesResponse)client.getAcsResponse((AcsRequest)request);
            return response;
        }
        catch (ClientException e) {
            throw new AudienceException(AudienceErrorCode.GET_AUDIENCE_LIST_ERROR, new Object[]{tenantId});
        }
    }

    @Override
    public List<CompanyTenantMappinBO> getTenantList() {
        List<CompanyTenantMappinBO> companyTenantMappinList = this.companyTenantMappinService.getTenantList();
        return companyTenantMappinList;
    }

    @Override
    public Boolean insterAudienceDownload(AudienceDownloadBO audienceDownloadBO) {
        AudienceDownloadEntity audienceDownloadEntity = (AudienceDownloadEntity)BeanConvertUtils.convert((Object)audienceDownloadBO, AudienceDownloadEntity.class);
        int result = this.audienceDownloadMapper.insert(audienceDownloadEntity);
        if (result < 1) {
            log.info("audienceDownloadBO inster to db error audienceId:{}", (Object)audienceDownloadEntity.getAudienceId());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean insterAudienceDownloadLog(AudienceDownloadLogBO audienceDownloadLogBO) {
        AudienceDownloadLogEntity audienceDownloadLogEntity = (AudienceDownloadLogEntity)BeanConvertUtils.convert((Object)audienceDownloadLogBO, AudienceDownloadLogEntity.class);
        int result = this.audienceDownloadLogMapper.insert(audienceDownloadLogEntity);
        if (result < 1) {
            log.info("audienceDownloadLogBO inster to db error serialNumber:{}", (Object)audienceDownloadLogBO.getSerialNumber());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateAudienceDownload(AudienceDownloadBO audienceDownloadBO) {
        AudienceDownloadEntity audienceDownloadEntity = (AudienceDownloadEntity)BeanConvertUtils.convert((Object)audienceDownloadBO, AudienceDownloadEntity.class);
        int result = this.audienceDownloadMapper.updateBySerialNumberSelective(audienceDownloadEntity);
        if (result < 1) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateAudienceDownloadLog(AudienceDownloadLogBO audienceDownloadLogBO) {
        AudienceDownloadLogEntity audienceDownloadLogEntity = (AudienceDownloadLogEntity)BeanConvertUtils.convert((Object)audienceDownloadLogBO, AudienceDownloadLogEntity.class);
        int result = this.audienceDownloadLogMapper.updateBySerialNumberSelective(audienceDownloadLogEntity);
        if (result < 1) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean getAudienceExport(String audienceId) {
        return null;
    }

    @Override
    public Long insterAudienceLabelType(AudienceLabelTypeBO audienceLabelTypeBO) {
        AudienceLabelTypeEntity audienceLabelTypeEntity = (AudienceLabelTypeEntity)BeanConvertUtils.convert((Object)audienceLabelTypeBO, AudienceLabelTypeEntity.class);
        this.audienceLabelTypeMapper.insert(audienceLabelTypeEntity);
        return audienceLabelTypeEntity.getId();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={SQLException.class}, timeout=20)
    public Long insterMbrGroupType(String audienceName, Long sysCompanyId, Long brandId) {
        MbrGroupTypeDefEntity mbrGroupTypeDefEntity = new MbrGroupTypeDefEntity();
        mbrGroupTypeDefEntity.setGroupTypeName(audienceName);
        mbrGroupTypeDefEntity.setSysCompanyId(sysCompanyId);
        mbrGroupTypeDefEntity.setBrandId(brandId);
        this.mbrGroupTypeDefMapper.insert(mbrGroupTypeDefEntity);
        MbrGroupDefEntity mbrGroupDefEntity = new MbrGroupDefEntity();
        mbrGroupDefEntity.setName(audienceName);
        mbrGroupDefEntity.setSysCompanyId(sysCompanyId);
        mbrGroupDefEntity.setBrandId(brandId);
        mbrGroupDefEntity.setGroupId(mbrGroupTypeDefEntity.getMbrGroupTypeDefId());
        JSONObject groupJson = new JSONObject();
        groupJson.put(CONDITIONS_JSON, (Object)audienceName);
        mbrGroupDefEntity.setConditions(groupJson.toJSONString());
        this.mbrGroupDefMapper.insert(mbrGroupDefEntity);
        return mbrGroupTypeDefEntity.getMbrGroupTypeDefId();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={SQLException.class}, timeout=60)
    public String audienceListFlow(ListAudiencesResponse.Data.ContentItem contentItem, CompanyTenantMappinBO companyTenantMappinBO) {
        if (null != contentItem && null != companyTenantMappinBO) {
            AudienceDownloadBO audienceDownloadBO = this.getAudienceDownload(contentItem, companyTenantMappinBO);
            AudienceDownloadEntity audienceDownloadEntity = this.audienceDownloadMapper.selectByAudienceId(contentItem.getId());
            if (audienceDownloadEntity != null) {
                if (AudienceStatus.ANALYSIS_ING.equals(audienceDownloadEntity.getDataStatus())) {
                    String audienceKey = RedisKeyUtils.key((String)"AUDIENCE:AUDIENCEID:{0}:NUMBER:{1}:NAME:{2}:VERSION:{3}", (String[])new String[]{audienceDownloadEntity.getAudienceId(), "*", "*", "*"});
                    Set keys = this.redisTemplate.keys((Object)audienceKey);
                    Integer consumeCount = 0;
                    AudienceDownloadLogEntity audienceDownloadLogEntity = new AudienceDownloadLogEntity();
                    for (String key : keys) {
                        consumeCount = Integer.valueOf((String)this.redisTemplate.opsForValue().get((Object)key));
                        Long version = Long.valueOf(key.substring(key.lastIndexOf(":") + 1));
                        String serialNumber = key.substring(key.indexOf("NUMBER") + Separator.SEVEN, key.indexOf("NAME") - Separator.ONE);
                        audienceDownloadLogEntity.setConsumeCount(consumeCount);
                        audienceDownloadLogEntity.setSerialNumber(serialNumber);
                        this.audienceDownloadLogMapper.updateBySerialNumberSelective(audienceDownloadLogEntity);
                        this.redisTemplate.delete((Object)key);
                        this.audienceMapper.deleteByVersionAndAudienceId(version, audienceDownloadEntity.getAudienceId());
                    }
                } else {
                    log.info("audienceListFlow is not need compensation data");
                }
                audienceDownloadEntity.setDataStatus(AudienceStatus.INIT);
                audienceDownloadEntity.setSerialNumber(audienceDownloadBO.getSerialNumber());
                this.audienceDownloadMapper.updateByPrimaryKeySelective(audienceDownloadEntity);
            } else {
                this.insterAudienceDownload(audienceDownloadBO);
            }
            Long labelId = this.insterAudienceLabelType(this.getAudienceLabelType(contentItem.getName(), companyTenantMappinBO.getSysCompanyId(), companyTenantMappinBO.getSysBrandId()));
            Long groupId = this.insterMbrGroupType(contentItem.getName(), companyTenantMappinBO.getSysCompanyId(), companyTenantMappinBO.getSysBrandId());
            String countKey = RedisKeyUtils.key((String)"AUDIENCE:RECORD:COUNT:AUDIENCEID:{0}", (String[])new String[]{contentItem.getId()});
            this.redisTemplate.opsForValue().set((Object)countKey, (Object)contentItem.getNumberOfAudiences());
            this.insterAudienceDownloadLog(this.getAudienceDownloadLogBO(audienceDownloadBO, labelId, groupId, contentItem.getNumberOfAudiences()));
            return audienceDownloadBO.getSerialNumber();
        }
        return null;
    }

    @Override
    public List<AudienceDownloadEntity> selectByDataStatus(Integer status) {
        return this.audienceDownloadMapper.selectByDataStatus(status);
    }

    public AudienceDownloadBO getAudienceDownload(ListAudiencesResponse.Data.ContentItem contentItem, CompanyTenantMappinBO companyTenantMappinBO) {
        AudienceDownloadBO audienceDownloadBO = new AudienceDownloadBO();
        audienceDownloadBO.setAudienceId(contentItem.getId());
        audienceDownloadBO.setAudienceName(contentItem.getName());
        audienceDownloadBO.setDataStatus(AudienceStatus.INIT);
        audienceDownloadBO.setSysCompanyId(companyTenantMappinBO.getSysCompanyId());
        audienceDownloadBO.setSysBrandId(companyTenantMappinBO.getSysBrandId());
        audienceDownloadBO.setSerialNumber(this.idWorker.nextId());
        audienceDownloadBO.setTenantId(companyTenantMappinBO.getTenantId());
        return audienceDownloadBO;
    }

    public AudienceLabelTypeBO getAudienceLabelType(String name, Long companyId, Long brandId) {
        AudienceLabelTypeBO audienceLabelTypeBO = new AudienceLabelTypeBO();
        audienceLabelTypeBO.setSysCompanyId(companyId);
        audienceLabelTypeBO.setSysBrandId(brandId);
        audienceLabelTypeBO.setLabelName(name);
        return audienceLabelTypeBO;
    }

    public AudienceDownloadLogBO getAudienceDownloadLogBO(AudienceDownloadBO audienceDownloadBO, Long labelId, Long groupId, String recordCount) {
        AudienceDownloadLogBO audienceDownloadLogBO = new AudienceDownloadLogBO();
        audienceDownloadLogBO.setSerialNumber(audienceDownloadBO.getSerialNumber());
        audienceDownloadLogBO.setAckStatus(Boolean.FALSE);
        audienceDownloadLogBO.setDownloadStatus(AudienceStatus.DOWNLOAD_STATUS_INIT);
        audienceDownloadLogBO.setInformStatus(AudienceStatus.INFORM_STATUS_INIT);
        audienceDownloadLogBO.setRequestStatus(AudienceStatus.CREATE_STATUS_INIT);
        audienceDownloadLogBO.setAudienceLabelTypeId(labelId);
        audienceDownloadLogBO.setMbrGroupTypeDefId(groupId);
        audienceDownloadLogBO.setRecordCount(Integer.valueOf(recordCount));
        return audienceDownloadLogBO;
    }
}

