/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.utils;

import cn.hutool.extra.spring.SpringUtil;
import feign.Contract;
import feign.Feign;
import feign.Target;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class ModifyFeign2NativeUtils {
    private static final Logger log = LoggerFactory.getLogger(ModifyFeign2NativeUtils.class);

    public static void modifyBean(Class t, String beanName, String url, String path, String host, Integer port) {
        ApplicationContext ac = SpringUtil.getApplicationContext();
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)ac;
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)context.getBeanFactory();
        Object obj = ac.getBean(t);
        try {
            if (Proxy.isProxyClass(obj.getClass())) {
                InvocationHandler ih = Proxy.getInvocationHandler(obj);
                Field targetField = ih.getClass().getDeclaredField("target");
                targetField.setAccessible(true);
                Target target = (Target)targetField.get(ih);
                Field nameField = target.getClass().getDeclaredField("name");
                nameField.setAccessible(true);
                String serviceName = (String)nameField.get(target);
                if (StringUtils.isNotBlank((CharSequence)url)) {
                    Field urlField = target.getClass().getDeclaredField("url");
                    urlField.setAccessible(true);
                    urlField.set(target, url);
                    Object bean = Feign.builder().contract((Contract)new SpringMvcContract()).build().newInstance(target);
                    BeanDefinition oldBeanDefinition = beanFactory.getBeanDefinition(beanName);
                    beanFactory.removeBeanDefinition(beanName);
                    oldBeanDefinition.setBeanClassName(beanName);
                    beanFactory.registerBeanDefinition(beanName, oldBeanDefinition);
                    beanFactory.registerSingleton(beanName, bean);
                }
            }
        }
        catch (Exception e) {
            log.error("\u91cd\u65b0\u6ce8\u518cBean\u5931\u8d25,exception={}", (Throwable)e);
        }
    }
}

