/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.utils;

import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HttpClient {
    private static Logger logger = LoggerFactory.getLogger((String)HttpClient.class.getName());
    private static final String CHARSET = "utf-8";
    private static final String CONTEXT_TYPE = "application/json;CHARSET=UTF-8";
    private static final Integer TIME_OUT = 30000;

    public String doPostJson(String url, String json) throws Exception {
        RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(TIME_OUT.intValue()).setConnectTimeout(TIME_OUT.intValue()).setConnectionRequestTimeout(TIME_OUT.intValue()).build();
        PoolingHttpClientConnectionManager clientConnectionManager = new PoolingHttpClientConnectionManager();
        clientConnectionManager.setValidateAfterInactivity(2000);
        clientConnectionManager.setMaxTotal(50);
        clientConnectionManager.setDefaultMaxPerRoute(50);
        CloseableHttpClient httpClient = HttpClients.createMinimal((HttpClientConnectionManager)clientConnectionManager);
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(json, CHARSET);
            entity.setContentType(CONTEXT_TYPE);
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setConfig(defaultRequestConfig);
            response = httpClient.execute((HttpUriRequest)httpPost);
            resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)CHARSET);
        }
        catch (SocketTimeoutException e) {
            throw new SocketTimeoutException("\u8c03\u7528:" + url + "\u8d85\u65f6");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error("close CloseableHttpResponse error By HttpClient line 66");
                }
            }
        }
        return resultString;
    }
}

