/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.UnionPayService;
import com.bizvane.appletservice.models.po.SysRechargeOrderPoExample;
import com.bizvane.appletservice.models.po.SysRechargeOrderPoWithBLOBs;
import com.bizvane.appletservice.models.vo.CreateGitfCardOrderVo;
import com.bizvane.appletservice.models.vo.CreateRechargeVO;
import com.bizvane.appletservice.models.vo.UnionPay2MQVo;
import com.bizvane.appletservice.models.vo.UnionPayCallBackVO;
import com.bizvane.appletserviceimpl.common.PayOrderStatusEnum;
import com.bizvane.appletserviceimpl.enums.OrderNoGeneratePrefixEnum;
import com.bizvane.appletserviceimpl.mappers.SysRechargeOrderPoMapper;
import com.bizvane.appletserviceimpl.utils.MD5Utils;
import com.bizvane.appletserviceimpl.utils.WxConfig;
import com.bizvane.base.common.bean.PayPackageResult;
import com.bizvane.base.common.bean.ResultBean;
import com.bizvane.base.remote.service.IRemotePayService;
import com.bizvane.centerstageservice.models.po.MbrRechargeRecordPo;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.MbrRechargeServiceRpc;
import com.bizvane.customized.facade.utils.UUIDUtil;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.mktcenterservice.rpc.ActivityPayServiceRpc;
import com.bizvane.serviceCard.interfaces.GiftCardStandardServiceFeign;
import com.bizvane.serviceCard.models.dto.giftCard.ReqGiftCardInfoDTO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.redisutils.RedissonTemplate;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatenterprise.service.common.DateUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class UnionPayServiceImpl
implements UnionPayService {
    private static final Logger log = LoggerFactory.getLogger(UnionPayServiceImpl.class);
    @Autowired
    private WxConfig wxConfig;
    @Autowired
    private SysRechargeOrderPoMapper sysRechargeOrderPoMapper;
    @Autowired
    IRemotePayService iRemotePayService;
    @Autowired
    BrandServiceRpc brandServiceRpc;
    @Autowired
    MbrRechargeServiceRpc mbrRechargeServiceRpc;
    @Autowired
    MemberInfoApiService memberInfoApiService;
    @Autowired
    ActivityPayServiceRpc activityPayServiceRpc;
    @Autowired
    private RedissonTemplate redissonTemplate;
    @Autowired
    RocketMQTemplate rocketMQTemplate;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private GiftCardStandardServiceFeign giftCardStandardServiceFeign;
    private static final String PRIVATE_PURCHASE = "\u79c1\u4eba\u8d2d\u4e70";
    private static final String PAY_TYPE = "UNION_TYPE";
    private static final String CALLBACK_SUCCESS = "SUCCESS";
    private static final String CALLBACK_FAIL = "FAIL";
    private static final String TIME_FORMATTER = "yyyy-MM-dd HH:mm:ss";

    public ResponseData createRechargeOrder(CreateRechargeVO vo, SysBrandPo brandPo, MemberInfoModel model, String appId) {
        ResponseData responseData = new ResponseData();
        String serialNumber = UnionPayServiceImpl.getSerialNumber((OrderNoGeneratePrefixEnum)OrderNoGeneratePrefixEnum.CHUZHI_CARD_ONLINE_NEW);
        Integer totalFee = this.getCentAmount(vo.getMoney(), appId);
        String attach = this.getAttach(vo, model);
        String salt = brandPo.getBizvaneSecretKey();
        String cryptData = MD5Utils.encode((String)(brandPo.getBizvaneMid() + "UNION_TYPE"), (String)salt).toUpperCase();
        log.info("createRechargeOrder cryptData:{},totalFee:{},attach:{}", new Object[]{cryptData, totalFee, attach});
        ResultBean preOrderResult = this.iRemotePayService.createPreOrder(brandPo.getBizvaneMid(), serialNumber, "", model.getName(), "\u79c1\u4eba\u8d2d\u4e70", model.getWxOpenId(), "", totalFee, "", "", "UNION_TYPE", attach, cryptData);
        log.info("createRechargeOrder resp:{}", (Object)JSONObject.toJSONString((Object)preOrderResult));
        if (Boolean.FALSE.equals(preOrderResult.getSuccess()) || Boolean.TRUE.equals(preOrderResult.getSuccess()) && "FAIL".equals(((PayPackageResult)preOrderResult.getResult()).getResultCode())) {
            responseData.setMessage("\u8c03\u7528\u652f\u4ed8\u670d\u52a1\u5f02\u5e38");
            responseData.setCode(-100);
            return responseData;
        }
        PayPackageResult result = (PayPackageResult)preOrderResult.getResult();
        this.insertRechargeOrder(vo, model, serialNumber, totalFee, result, attach);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", result.getAppid());
        map.put("timeStamp", result.getTimeStamp());
        map.put("nonceStr", result.getNonceStr());
        map.put("package", result.getPrepayId());
        map.put("signType", "RSA");
        map.put("paySign", result.getSign());
        responseData.setData(map);
        return responseData;
    }

    public ResponseData transit(CreateRechargeVO vo, HttpServletRequest request) {
        log.info("UnionPayServiceImpl transit param:{}", (Object)JSONObject.toJSONString((Object)vo));
        ResponseData responseData = new ResponseData();
        String sysBrandId = request.getHeader("sysBrandId");
        if (StringUtils.isBlank((CharSequence)sysBrandId)) {
            responseData.setCode(100);
            responseData.setMessage("\u83b7\u53d6\u54c1\u724cid\u9519\u8bef");
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u65e0bizvaneSessionId");
            responseData.setCode(100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)vo.getMoney()) || new BigDecimal(vo.getMoney()).compareTo(new BigDecimal("0")) <= 0) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u6b63\u786e\u91d1\u989d");
            responseData.setCode(100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        memberInfoModel.setBrandId(Long.valueOf(sysBrandId));
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel model = (MemberInfoModel)singleMemberModel.getData();
        if (model == null) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        String appId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        vo.setOpenid(openId);
        vo.setAppId(appId);
        vo.setMemberCode(memberCode);
        ResponseData brandResp = this.brandServiceRpc.getBrandByID(Long.valueOf(sysBrandId));
        if (brandResp.getCode() == SysResponseEnum.FAILED.getCode() || brandResp.getData() == null) {
            responseData.setMessage("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u5931\u8d25");
            responseData.setCode(-100);
            return responseData;
        }
        SysBrandPo brandPo = (SysBrandPo)brandResp.getData();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{brandPo.getBizvaneMid(), brandPo.getBizvaneSecretKey()})) {
            responseData.setMessage("\u5546\u6237\u94f6\u8054\u652f\u4ed8\u4fe1\u606f\u672a\u914d\u7f6e");
            responseData.setCode(-100);
            return responseData;
        }
        return this.createRechargeOrder(vo, brandPo, model, appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public ResponseData<String> unionRechargeCallBack(UnionPayCallBackVO vo) throws Exception {
        ResponseData responseData = new ResponseData();
        JSONObject attachObj = JSONObject.parseObject((String)vo.getAttach());
        Long sysBrandId = Long.parseLong(String.valueOf(attachObj.get((Object)"bid")));
        try {
            List<String> ids;
            ResponseData brandResp = this.brandServiceRpc.getBrandByID(sysBrandId);
            if (brandResp.getCode() == SysResponseEnum.FAILED.getCode() || brandResp.getData() == null) {
                log.info("unionRechargeCallBack \u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u9519\u8bef");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                responseData.setData((Object)"FAIL");
                ResponseData responseData2 = responseData;
                return responseData2;
            }
            SysBrandPo brandInfo = (SysBrandPo)brandResp.getData();
            String sign = MD5Utils.encode((String)(vo.getBizvaneMid() + "UNION_TYPE"), (String)brandInfo.getBizvaneSecretKey()).toUpperCase();
            if (!vo.getCryptData().equals(sign)) {
                log.info("unionRechargeCallBack \u9a8c\u7b7e\u5931\u8d25");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                responseData.setData((Object)"FAIL");
                ResponseData responseData3 = responseData;
                return responseData3;
            }
            log.info("\u8ba2\u5355\u53f7\u662f:{}", (Object)vo.getOutTradeNo());
            if (UnionPayServiceImpl.isGitfCard((String)vo.getOutTradeNo())) {
                ResponseData responseData4 = this.execGitfCardService(vo.getOutTradeNo(), vo.getTotalFee(), vo.getTransactionid(), vo.getAttach());
                return responseData4;
            }
            this.redissonTemplate.getRLock(sysBrandId + vo.getTransactionid(), 90L, TimeUnit.SECONDS);
            SysRechargeOrderPoExample example = new SysRechargeOrderPoExample();
            example.createCriteria().andBizvaneTradeNoEqualTo(vo.getBizvaneTradeNo()).andOutTradeNoEqualTo(vo.getOutTradeNo()).andSysBrandIdEqualTo(sysBrandId);
            List poWithBLOBs = this.sysRechargeOrderPoMapper.selectByExampleWithBLOBs(example);
            if (CollectionUtils.isEmpty((Collection)poWithBLOBs)) {
                log.info("unionRechargeCallBack \u67e5\u8be2\u9884\u5145\u503c\u5355\u6d41\u6c34\u5931\u8d25");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                responseData.setData((Object)"FAIL");
                ResponseData responseData5 = responseData;
                return responseData5;
            }
            SysRechargeOrderPoWithBLOBs po = (SysRechargeOrderPoWithBLOBs)poWithBLOBs.get(0);
            if (!PayOrderStatusEnum.WAIT_PAY.getCode().equals(po.getStatus())) {
                log.info("unionRechargeCallBack \u5df2\u652f\u4ed8 \u652f\u4ed8\u670d\u52a1\u91cd\u590d\u8c03\u7528");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                responseData.setData((Object)"FAIL");
                ResponseData responseData6 = responseData;
                return responseData6;
            }
            Double money = Double.parseDouble(vo.getTotalFee()) / (double)this.wxConfig.getMoneyCode().intValue();
            String testBrand = this.wxConfig.getTestBrand();
            if (StringUtils.isNotEmpty((CharSequence)testBrand) && (ids = Arrays.asList(testBrand.split(","))).contains(po.getAppId())) {
                money = money * 100.0;
            }
            String memberCode = String.valueOf(attachObj.get((Object)"mC"));
            MemberInfoModel member = this.getMemberInfoModel(brandInfo, memberCode);
            Integer status = null;
            for (PayOrderStatusEnum value : PayOrderStatusEnum.values()) {
                if (!value.getMessage().equals(vo.getPayStatus())) continue;
                status = value.getCode();
            }
            po.setPlatSerialNum(vo.getTransactionid());
            po.setStatus(status);
            po.setModifiedDate(new Date());
            po.setPayServiceStatus(vo.getPayStatus());
            int count = this.sysRechargeOrderPoMapper.updateByPrimaryKeySelective(po);
            if (count == 0) {
                log.info("unionRechargeCallBack \u66f4\u65b0\u5145\u503c\u6d41\u6c34\u72b6\u6001\u5931\u8d25");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(SysResponseEnum.FAILED.getMessage());
                responseData.setData((Object)"FAIL");
                ResponseData responseData7 = responseData;
                return responseData7;
            }
            if (PayOrderStatusEnum.PAY_SUCCESS.getMessage().equals(vo.getPayStatus())) {
                String activityId = String.valueOf(attachObj.get((Object)"aid"));
                UnionPay2MQVo mqMessage = UnionPay2MQVo.builder().cardNo(member.getCardNo()).createDate(DateUtil.parse((String)vo.getTimeEnd(), (String)"yyyy-MM-dd HH:mm:ss")).erpId(member.getErpId()).giveMoney((Double)ObjectUtils.defaultIfNull((Object)po.getGiveMoney().doubleValue(), (Object)0.0)).rechargeMoney(money).levelId(member.getLevelId()).memberCode(member.getMemberCode()).paymentDate(DateUtil.parse((String)vo.getTimeEnd(), (String)"yyyy-MM-dd HH:mm:ss")).name(member.getName()).payId(StringUtils.isBlank((CharSequence)activityId) ? null : Integer.valueOf(activityId)).state(Long.valueOf(0L)).sysBrandId(sysBrandId).payVoucherNo(vo.getTransactionid()).build();
                SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic("public_union_pay_recharge_record").build(), (Object)JSON.toJSONString((Object)mqMessage));
                log.info("unionRechargeCallBack sendResult:{}", (Object)JSONObject.toJSONString((Object)sendResult));
            }
        }
        finally {
            this.redissonTemplate.getRUnLook(sysBrandId + vo.getTransactionid());
        }
        responseData.setData((Object)"SUCCESS");
        return responseData;
    }

    public ResponseData<String> execGitfCardService(String out_trade_no, String total_fee, String transaction_id, String attachStr) {
        ResponseData responseData = new ResponseData();
        com.alibaba.fastjson.JSONObject attach = JSON.parseObject((String)attachStr);
        String serviceDefinitionId = attach.getString("did");
        String cardNo = attach.getString("Co");
        String sysBrandId = attach.getString("bid");
        String sysCompanyId = attach.getString("cid");
        String memberCode = attach.getString("mC");
        ReqGiftCardInfoDTO dto = new ReqGiftCardInfoDTO();
        dto.setSysCompanyId(Long.valueOf(Long.parseLong(sysCompanyId)));
        dto.setSysBrandId(Long.valueOf(Long.parseLong(sysBrandId)));
        dto.setMemberCode(memberCode);
        dto.setCardGiftDefinitionId(Long.valueOf(Long.parseLong(serviceDefinitionId)));
        dto.setGiftCardNo(cardNo);
        log.info("\u8bf7\u6c42service-card\u66f4\u65b0\u8ba2\u5355\u72b6\u6001:{}", (Object)JSON.toJSONString((Object)dto));
        ResponseData paied = this.giftCardStandardServiceFeign.paied(dto);
        if (paied.getCode() != 0) {
            log.info("\u4fee\u6539service-card \u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u4ed8\u6b3e \u5931\u8d25:{}", (Object)paied.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setData((Object)"FAIL");
            return responseData;
        }
        responseData.setData((Object)"SUCCESS");
        return responseData;
    }

    private static boolean isGitfCard(String outTradeNo) {
        if (StringUtils.isNotEmpty((CharSequence)outTradeNo)) {
            String sufixValue = outTradeNo.substring(0, 2);
            return sufixValue.equals(OrderNoGeneratePrefixEnum.SERVICE_GIFT.getSufixValue());
        }
        throw new RuntimeException("\u8ba2\u5355\u53f7\u662f\u7a7a\u7684");
    }

    private MemberInfoModel getMemberInfoModel(SysBrandPo brandInfo, String memberCode) {
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        memberInfoModel.setSysCompanyId(brandInfo.getSysCompanyId());
        memberInfoModel.setBrandId(brandInfo.getSysBrandId());
        ResponseData memberInfoModelResponseData = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        return (MemberInfoModel)memberInfoModelResponseData.getData();
    }

    private ResponseData addRechargeRecord(String transactionid, String timeEnd, SysRechargeOrderPoWithBLOBs po, Double money, MemberInfoModel member) {
        MbrRechargeRecordPo recordPo = new MbrRechargeRecordPo();
        recordPo.setErpId(member.getErpId());
        recordPo.setName(member.getName());
        recordPo.setCardNo(member.getCardNo());
        recordPo.setSysBrandId(member.getBrandId());
        recordPo.setRechargeMoney(money);
        recordPo.setGiveMoney((Double)ObjectUtils.defaultIfNull((Object)po.getGiveMoney().doubleValue(), (Object)0.0));
        recordPo.setPayVoucherNo(transactionid);
        recordPo.setState(Long.valueOf(0L));
        recordPo.setCreateDate(DateUtil.parse((String)timeEnd, (String)"yyyy-MM-dd HH:mm:ss"));
        recordPo.setPaymentDate(DateUtil.parse((String)timeEnd, (String)"yyyy-MM-dd HH:mm:ss"));
        log.info("UnionPayServiceImpl addRechargeRecord params:{}", (Object)JSONObject.toJSONString((Object)recordPo));
        return this.mbrRechargeServiceRpc.addMbrRechargeRecord(recordPo);
    }

    private void insertRechargeOrder(CreateRechargeVO vo, MemberInfoModel model, String serialNumber, Integer totalFee, PayPackageResult result, String attach) {
        SysRechargeOrderPoWithBLOBs preOrder = new SysRechargeOrderPoWithBLOBs();
        preOrder.setBizvaneTradeNo(result.getBizvaneTradeNo());
        preOrder.setCreateDate(new Date());
        preOrder.setGiveMoney(new BigDecimal(vo.getGiveMoney()));
        preOrder.setOutTradeNo(serialNumber);
        preOrder.setMemberCode(model.getMemberCode());
        preOrder.setOpenId(model.getWxOpenId());
        preOrder.setPayType(Integer.valueOf(0));
        preOrder.setRechargeMoney(new BigDecimal(vo.getMoney()));
        preOrder.setStatus(PayOrderStatusEnum.WAIT_PAY.getCode());
        preOrder.setSysCompanyId(model.getSysCompanyId());
        preOrder.setSysBrandId(model.getBrandId());
        preOrder.setAttach(attach);
        preOrder.setTotalFee(totalFee);
        preOrder.setAppId(result.getAppid());
        this.sysRechargeOrderPoMapper.insertSelective(preOrder);
    }

    private String getAttach(CreateRechargeVO vo, MemberInfoModel model) {
        HashMap<String, String> attachMap = new HashMap<String, String>();
        attachMap.put("m", vo.getGiveMoney());
        attachMap.put("mC", model.getMemberCode());
        attachMap.put("aid", vo.getActivityId());
        attachMap.put("bid", model.getBrandId().toString());
        attachMap.put("cid", model.getSysCompanyId().toString());
        return JSONObject.toJSONString(attachMap);
    }

    private String getAttach(CreateGitfCardOrderVo vo, MemberInfoModel model) {
        HashMap<String, String> attachMap = new HashMap<String, String>();
        attachMap.put("Co", vo.getCardNo());
        attachMap.put("mC", model.getMemberCode());
        attachMap.put("did", vo.getServiceCardDefinitionId());
        attachMap.put("bid", model.getBrandId().toString());
        attachMap.put("cid", model.getSysCompanyId().toString());
        return JSONObject.toJSONString(attachMap);
    }

    private static String getSerialNumber(OrderNoGeneratePrefixEnum enu) {
        String format = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        return enu.getSufixValue() + format + UUIDUtil.getUUID().substring(0, 4);
    }

    private Integer getCentAmount(String amount, String appId) {
        Integer value = null;
        String testBrand = this.wxConfig.getTestBrand();
        if (StringUtils.isNotEmpty((CharSequence)testBrand)) {
            List<String> ids = Arrays.asList(testBrand.split(","));
            if (ids.contains(appId)) {
                value = Integer.parseInt(amount);
            } else {
                Integer integer = Integer.valueOf(amount);
                value = integer * this.wxConfig.getMoneyCode();
            }
        }
        return value;
    }
}

