/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.interfaces.IntegralExchangeService;
import com.bizvane.members.facade.models.bo.CompanyExchangeIntegralBo;
import com.bizvane.members.facade.service.qywxapi.CompanyIntegralApiService;
import com.bizvane.members.facade.vo.qywx.IntegralExchangeRequestVo;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IntegralExchangeServiceImpl
implements IntegralExchangeService {
    private static final Logger log = LoggerFactory.getLogger(IntegralExchangeServiceImpl.class);
    @Autowired
    private CompanyIntegralApiService companyIntegralApiService;

    public ResponseData query(Long sysBrandId, Long sysCompanyId, String memberCode) {
        ResponseData result = this.companyIntegralApiService.queryYouZanExchangeIntegral(sysCompanyId, sysBrandId);
        Integer integralBalance = (Integer)this.companyIntegralApiService.queryMemberIntegral(memberCode).getData();
        CompanyExchangeIntegralBo bo = (CompanyExchangeIntegralBo)result.getData();
        ResponseData data = new ResponseData();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("crmIntegral", bo.getCrmIntegral());
        map.put("otherIntegral", bo.getOtherIntegral());
        map.put("description", bo.getDescription());
        map.put("integralBalance", integralBalance);
        data.setMessage(SysResponseEnum.SUCCESS.getMessage());
        data.setCode(SysResponseEnum.SUCCESS.getCode());
        data.setData(map);
        return data;
    }

    public ResponseData exchangeDetail(Integer exchangeCounts, Long sysBrandId, Long sysCompanyId) {
        return this.calculate(exchangeCounts, sysBrandId, sysCompanyId);
    }

    public ResponseData confirmExchange(String memberCode, Long sysCompanyId, Long sysBrandId, Integer exchangeCounts) {
        ResponseData data = this.calculate(exchangeCounts, sysBrandId, sysCompanyId);
        Map map = (Map)data.getData();
        IntegralExchangeRequestVo vo = new IntegralExchangeRequestVo();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyymmddHHmmssSSS");
        vo.setMemberCode(memberCode);
        vo.setBrandId(sysBrandId);
        vo.setSysCompanyId(sysCompanyId);
        vo.setDecreaseCrmIntegral(Integer.valueOf((String)map.get("deductCrm")));
        vo.setIncreaseOtherIntegral(Integer.valueOf((String)map.get("youzanCount")));
        vo.setChangeDate(new Date());
        vo.setChangeBills(sdf.format(new Date()) + (int)((Math.random() * 9.0 + 1.0) * 1000.0));
        log.info("\u8c03\u7528\u5151\u6362\u79ef\u5206\u5165\u53c2={}", (Object)JSON.toJSONString((Object)vo));
        return this.companyIntegralApiService.convertYouZanExchangeIntegral(vo);
    }

    private ResponseData calculate(Integer exchangeCounts, Long sysBrandId, Long sysCompanyId) {
        ResponseData data = new ResponseData();
        ResponseData result = this.companyIntegralApiService.queryYouZanExchangeIntegral(sysCompanyId, sysBrandId);
        CompanyExchangeIntegralBo bo = (CompanyExchangeIntegralBo)result.getData();
        Integer crmExchange = bo.getCrmIntegral();
        Integer youZanExchange = bo.getOtherIntegral();
        BigDecimal bigDecimal = new BigDecimal(exchangeCounts);
        BigDecimal decimal2 = new BigDecimal(crmExchange);
        BigDecimal decimal = bigDecimal.divideToIntegralValue(decimal2);
        BigDecimal youzanCount = decimal.multiply(new BigDecimal(youZanExchange));
        BigDecimal deductCrm = decimal.multiply(new BigDecimal(crmExchange));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("deductCrm", deductCrm.toString());
        map.put("youzanCount", youzanCount.toString());
        data.setData(map);
        data.setCode(SysResponseEnum.SUCCESS.getCode());
        return data;
    }
}

