/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.idempotent;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletserviceimpl.idempotent.Idempotent;
import com.bizvane.appletserviceimpl.idempotent.IdempotentKeyUtil;
import com.bizvane.utils.redisutils.RedisTemplateService;
import com.bizvane.utils.responseinfo.ResponseData;
import java.lang.reflect.Method;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Component
@Aspect
@ConditionalOnClass(value={RedisTemplate.class})
public class IdempotentAspect {
    private static final Logger log = LoggerFactory.getLogger(IdempotentAspect.class);
    private static final String KEY_TEMPLATE = "idempotent_%s";
    @Autowired
    private RedisTemplateService<String, String> stringRedisTemplate;

    @Pointcut(value="@annotation(com.bizvane.appletserviceimpl.idempotent.Idempotent)")
    public void executeIdempotent() {
    }

    @Around(value="executeIdempotent()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        Idempotent idempotent = method.getAnnotation(Idempotent.class);
        String type = idempotent.type();
        Object[] args = joinPoint.getArgs();
        Object[] print = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            print[i] = args[i] instanceof ServletRequest ? "ServletRequest" : (args[i] instanceof ServletResponse ? "ServletResponse" : (args[i] instanceof MultipartFile ? "MultipartFile" : args[i]));
        }
        String key = String.format(KEY_TEMPLATE, idempotent.value() + "_" + IdempotentKeyUtil.generate((Method)method, (Object[])print));
        String redisResponse = (String)this.stringRedisTemplate.stringGetStringByKey((Object)key);
        if (!StringUtils.isEmpty((Object)redisResponse)) {
            log.info("IdempotentAspect # joinPoint.getArgs():{}", (Object)JSON.toJSONString((Object)print));
            ResponseData responseData = new ResponseData();
            responseData.setCode(100);
            responseData.setMessage("\u64cd\u4f5c\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            return responseData;
        }
        this.stringRedisTemplate.stringSetValueAndExpireTime((Object)key, (Object)key, idempotent.expireMillis());
        return joinPoint.proceed();
    }
}

