/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.vg;

import com.alibaba.fastjson.JSON;
import com.bizvane.appletservice.interfaces.WechatAppletSubscribeMsgService;
import com.bizvane.appletservice.models.vo.vg.VGSubscribeMessageCloseRequestVo;
import com.bizvane.appletservice.models.vo.vg.VGSubscribeMessageRequestVo;
import com.bizvane.appletservice.models.vo.vg.VGSubscribeMsgAuthRequestVo;
import com.bizvane.appletservice.models.vo.vg.VGSubscribeMsgAuthResponseVo;
import com.bizvane.messagefacade.models.vo.vg.WechatAppletSubscribeResponseVo;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vgSubscribeMsg"})
public class VGWechatAppletSubscribeMsgController {
    private static final Logger log = LoggerFactory.getLogger(VGWechatAppletSubscribeMsgController.class);
    @Autowired
    private WechatAppletSubscribeMsgService wechatAppletSubscribeMsgService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;

    @PostMapping(value={"querySubscribeMsgAuth"})
    ResponseData<? extends WechatAppletSubscribeResponseVo> queryBrandWechatxAppletSubscribe(@RequestBody @Valid VGSubscribeMsgAuthRequestVo subscribeMsgAuthRequestVo) {
        log.info("querySubscribeMsgAuth:{}", (Object)JSON.toJSONString((Object)subscribeMsgAuthRequestVo));
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = this.request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String sysBrandIdRedis = (String)this.redisTemplateService.stringGetStringByKey((Object)("sysBrandId" + bizvaneSessionId));
        if (subscribeMsgAuthRequestVo.getBrandId() == null && StringUtils.isBlank((CharSequence)sysBrandIdRedis)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u518d\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        if (subscribeMsgAuthRequestVo.getBrandId() == null) {
            subscribeMsgAuthRequestVo.setBrandId(Long.valueOf(sysBrandIdRedis));
        }
        VGSubscribeMsgAuthResponseVo vgSubscribeMsgAuthResponseVo = this.wechatAppletSubscribeMsgService.queryBrandWechatAppletSubscribeDataRedis(subscribeMsgAuthRequestVo);
        responseData.setData((Object)vgSubscribeMsgAuthResponseVo);
        log.info("wechatAppletSubscribeMsgService.queryBrandWechatAppletSubscribe:{}", (Object)JSON.toJSONString((Object)responseData));
        return responseData;
    }

    @GetMapping(value={"clearSubscribeMsgAuth"})
    ResponseData<String> clearSubscribeMsgAuth(@Valid VGSubscribeMsgAuthRequestVo subscribeMsgAuthRequestVo) {
        log.info("clearSubscribeMsgAuth:{}", (Object)JSON.toJSONString((Object)subscribeMsgAuthRequestVo));
        ResponseData responseData = new ResponseData();
        this.wechatAppletSubscribeMsgService.clearBrandWechatAppletSubscribeDataRedis(subscribeMsgAuthRequestVo);
        log.info("wechatAppletSubscribeMsgService.clearBrandWechatAppletSubscribeDataRedis:{}", (Object)JSON.toJSONString((Object)responseData));
        return responseData;
    }

    @PostMapping(value={"subscribeMessageRequest"})
    ResponseData subscribeMessageRequest(@RequestBody @Valid VGSubscribeMessageRequestVo vgSubscribeMessageRequestVo) {
        ResponseData responseData = this.wechatAppletSubscribeMsgService.subscribeMessageRequest(vgSubscribeMessageRequestVo);
        log.info("wechatAppletSubscribeMsgService.subscribeMessageRequest:{}", (Object)JSON.toJSONString((Object)responseData));
        return responseData;
    }

    @PostMapping(value={"closeSubscribeMessage"})
    ResponseData closeSubscribeMessage(@RequestBody @Valid VGSubscribeMessageCloseRequestVo vgSubscribeMessageCloseRequestVo) {
        ResponseData responseData = this.wechatAppletSubscribeMsgService.closeSubscribeMessage(vgSubscribeMessageCloseRequestVo);
        log.info("wechatAppletSubscribeMsgService.closeSubscribeMessage:{}", (Object)JSON.toJSONString((Object)responseData));
        return responseData;
    }
}

