/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers.vg;

import com.bizvane.appletservice.models.po.AppletVipPrivilegePO;
import com.bizvane.appletservice.models.vo.vg.VGClubCardStatusRequestVO;
import com.bizvane.appletservice.models.vo.vg.VGSubscribeMsgAuthResponseVo;
import com.bizvane.appletserviceimpl.impl.vg.VGClubPageServiceImpl;
import com.bizvane.appletserviceimpl.impl.vg.VGCommonService;
import com.bizvane.appletserviceimpl.impl.vg.VGMemberDetailPageServiceImpl;
import com.bizvane.customized.facade.utils.ResponseUtils;
import com.bizvane.messagefacade.enums.vg.WechatSUbscribeMenuEnum;
import com.bizvane.utils.redisutils.RedisTemplateService;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import java.util.Collection;
import java.util.List;
import org.apache.catalina.servlet4preview.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"vg\u4ff1\u4e50\u90e8\u5c0f\u7a0b\u5e8f\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/vgClubPage"})
public class VGClubPageController {
    private static final Logger log = LoggerFactory.getLogger(VGClubPageController.class);
    @Autowired
    private RedisTemplateService<String, String> redisTemplateService;
    @Autowired
    private VGClubPageServiceImpl vgClubPageServiceImpl;
    @Autowired
    private VGMemberDetailPageServiceImpl vgMemberDetailPageService;
    @Autowired
    private VGCommonService vgCommonService;

    @GetMapping(value={"/getMemberClubCardStatus"})
    public ResponseData getMemberClubCardStatus(HttpServletRequest request) {
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        ResponseData result = new ResponseData();
        if (StringUtils.isEmpty((CharSequence)bizvaneSessionId)) {
            result.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return result;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        Long sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        Long sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
        log.info("VGGroupHomePageController#getMemberClubCardStatus#memberCode:{}", (Object)memberCode);
        VGClubCardStatusRequestVO clubCardStatusRequestVO = VGClubCardStatusRequestVO.builder().bizvaneSessionId(bizvaneSessionId).memberCode(memberCode).sysBrandId(sysBrandId).sysCompanyId(sysCompanyId).build();
        ResponseData memberClubCardStatus = this.vgClubPageServiceImpl.getMemberClubCardStatus(clubCardStatusRequestVO);
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        if (memberClubCardStatus != null && !CollectionUtils.isEmpty((Collection)((Collection)memberClubCardStatus.getData()))) {
            ((List)memberClubCardStatus.getData()).stream().forEach(e -> {
                VGSubscribeMsgAuthResponseVo vgSubscribeMsgAuthResponseVo = this.vgCommonService.queryBrandWechatAppletSubscribeDataRedis(e.getSysBrandId(), openId, WechatSUbscribeMenuEnum.FIELD_11);
                e.setVgSubscribeMsgAuthResponseVo(vgSubscribeMsgAuthResponseVo);
            });
        }
        return memberClubCardStatus;
    }

    @GetMapping(value={"/getMemberClubVipPrivilegeByLevel"})
    public ResponseData<List<AppletVipPrivilegePO>> getMemberClubVipPrivilege(@RequestParam Long sysBrandId, @RequestParam(required=false) Long levelId, @RequestParam(required=false, defaultValue="20") Integer num) {
        log.info("VGClubPageController#getMemberClubVipPrivilege#sysBrandId:{},level:{},num:{}", new Object[]{sysBrandId, levelId, num});
        return this.vgClubPageServiceImpl.getMemberClubVipPrivilege(sysBrandId, levelId, num);
    }

    @GetMapping(value={"/getMemberClubAllPrivilegeByLevel"})
    public ResponseData getMemberClubAllPrivilegeByLevel(@RequestParam Long sysBrandId, @RequestParam Long levelId) {
        log.info("VGClubPageController#getMemberClubVipPrivilege#sysBrandId:{},level:{}", (Object)sysBrandId, (Object)levelId);
        if (sysBrandId == null) {
            return ResponseUtils.getFailedData((String)"\u5546\u6237id\u4e3a\u7a7a");
        }
        if (levelId == null) {
            return ResponseUtils.getFailedData((String)"\u7b49\u7ea7id\u4e3a\u7a7a");
        }
        return this.vgClubPageServiceImpl.getMemberClubAllPrivilegeByLevel(sysBrandId, levelId);
    }

    @GetMapping(value={"/getLevelRatio"})
    public ResponseData getLevelRatio(@RequestParam Long sysBrandId, HttpServletRequest request) {
        log.info("VGClubPageController#getLevelRatio#sysBrandId:{}", (Object)sysBrandId);
        if (sysBrandId == null) {
            return ResponseUtils.getFailedData((String)"\u5546\u6237id\u4e3a\u7a7a");
        }
        if (sysBrandId.equals(160L) || sysBrandId.equals(161L) || sysBrandId.equals(162L)) {
            sysBrandId = 156L;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        ResponseData result = new ResponseData();
        if (StringUtils.isEmpty((CharSequence)bizvaneSessionId)) {
            result.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return result;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        return this.vgClubPageServiceImpl.getLevelRatio(sysBrandId, memberCode);
    }
}

