/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.interfaces.IntegrationShopService;
import com.bizvane.appletservice.interfaces.UnionPayService;
import com.bizvane.appletservice.interfaces.WxPayService;
import com.bizvane.appletservice.models.vo.CreateGitfCardOrderVo;
import com.bizvane.appletservice.models.vo.CreateRechargeVO;
import com.bizvane.appletserviceimpl.utils.MD5Util;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.WxPayConfigPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.MbrRechargeServiceRpc;
import com.bizvane.customized.facade.interfaces.RechargeCardServiceFeign;
import com.bizvane.customized.facade.models.po.CusUrRechargeCardPO;
import com.bizvane.customized.facade.models.vo.CusUrRechargeConfigVO;
import com.bizvane.customized.facade.models.vo.CusUrRechargeGiveVO;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.serviceCard.interfaces.GiftCardStandardServiceFeign;
import com.bizvane.serviceCard.models.dto.giftCard.ReqGiftCardInfoDTO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5145\u503c", tags={"\u5fae\u4fe1\u5145\u503c"})
@RestController
@RequestMapping(value={"/wxPay"})
public class WxPayController {
    private static final Logger log = LoggerFactory.getLogger(WxPayController.class);
    private static final Logger logger = LoggerFactory.getLogger(WxPayController.class);
    @Autowired
    private WxPayService wxPayService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MbrRechargeServiceRpc mbrRechargeServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private RechargeCardServiceFeign rechargeCardServiceFeign;
    @Value(value="${ur.brandId}")
    private Long brandId;
    @Value(value="${unionPay.brands}")
    private String unionPayBrands;
    @Value(value="${pay.salt}")
    private String paySalt;
    @Autowired
    private UnionPayService unionPayService;
    @Autowired
    private IntegrationShopService integrationShopService;
    @Autowired
    private GiftCardStandardServiceFeign giftCardStandardServiceFeign;
    @Autowired
    private BrandServiceRpc brandServiceRpc;

    @ApiOperation(value="\u521b\u5efa\u5145\u503c\u5355", notes="\u521b\u5efa\u5145\u503c\u5355")
    @PostMapping(value={"/createRecharge"})
    public ResponseData createRecharge(CreateRechargeVO vo, HttpServletRequest request) {
        logger.info("createRecharge pararm:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        ResponseData responseData = new ResponseData();
        if (bizvaneSessionId == null) {
            responseData.setMessage("bizvaneSessionId\u6ca1\u6709");
            responseData.setCode(100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        if ("0".equals(vo.getMoney()) || StringUtils.isBlank((CharSequence)vo.getMoney())) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u6b63\u786e\u91d1\u989d");
            responseData.setCode(100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel model = (MemberInfoModel)singleMemberModel.getData();
        if (model == null) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        WxPayConfigPo po = new WxPayConfigPo();
        po.setSysCompanyId(model.getSysCompanyId());
        po.setSysBrandId(model.getBrandId());
        String[] brands = this.unionPayBrands.split(",");
        if (Arrays.asList(brands).contains(String.valueOf(model.getBrandId()))) {
            return this.unionPayService.transit(vo, request);
        }
        ResponseData data = this.mbrRechargeServiceRpc.getWxPayConfigRpc(po);
        WxPayConfigPo wxConfig = (WxPayConfigPo)data.getData();
        if (wxConfig == null) {
            responseData.setMessage("\u5546\u6237\u4e0d\u5b58\u5728");
            responseData.setCode(100);
            return responseData;
        }
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        String appId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        vo.setOpenid(openId);
        vo.setAppId(appId);
        vo.setMemberCode(memberCode);
        if (this.brandId.equals(wxConfig.getSysBrandId())) {
            CusUrRechargeCardPO cardPO;
            CusUrRechargeCardPO rechargeCardPO = CusUrRechargeCardPO.builder().sysBrandId(wxConfig.getSysBrandId()).sysCompanyId(wxConfig.getSysCompanyId()).memberCode(memberCode).build();
            ResponseData debitCardInfo = this.rechargeCardServiceFeign.queryDebitCardInfo(rechargeCardPO);
            if (CollectionUtils.isNotEmpty((Collection)((Collection)debitCardInfo.getData())) && (cardPO = (CusUrRechargeCardPO)((List)debitCardInfo.getData()).get(0)).getCardStatus() == 0) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u60a8\u6709\u4e00\u7b14\u9000\u6b3e\u6d41\u7a0b\u6b63\u5728\u5ba1\u6838\u4e2d");
                return responseData;
            }
            ResponseData rechargeConfig = this.rechargeCardServiceFeign.getRechargeConfig(wxConfig.getSysCompanyId(), wxConfig.getSysBrandId());
            if (rechargeConfig.getData() == null || rechargeConfig.getCode() == SysResponseEnum.FAILED.getCode()) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u67e5\u8be2\u50a8\u84c4\u914d\u7f6e\u5f02\u5e38");
                return responseData;
            }
            CusUrRechargeConfigVO configData = (CusUrRechargeConfigVO)rechargeConfig.getData();
            if (StringUtils.isNotBlank((CharSequence)configData.getRechargeJson())) {
                String rechargeJson = configData.getRechargeJson();
                List giveList = JSONObject.parseArray((String)rechargeJson, CusUrRechargeGiveVO.class);
                giveList.forEach(rechargeInfo -> {
                    if (rechargeInfo.getAmount().equals(Long.valueOf(vo.getMoney()))) {
                        vo.setGiveMoney(String.valueOf(rechargeInfo.getGiveAmount()));
                    }
                });
            }
            logger.info("ur vo:{}", JSON.toJSON((Object)vo));
            BigDecimal money = new BigDecimal(vo.getMoney());
            BigDecimal giveMoney = new BigDecimal(vo.getGiveMoney());
            BigDecimal giveLimitAmount = configData.getGiveLimitAmount().multiply(new BigDecimal("10000"));
            if (configData.getGiveAmount().add(giveMoney).compareTo(giveLimitAmount) > 0) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u5f53\u524d\u5145\u503c\u989d\u5ea6\u5df2\u8d85\u9650\u989d\uff0c\u6682\u4e0d\u652f\u6301\u5145\u503c\u3002\u5982\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5ba2\u670d4006-513-512");
                return responseData;
            }
            if (configData.getEveryDayLimit() == 1 && CollectionUtils.isNotEmpty((Collection)((Collection)debitCardInfo.getData()))) {
                if (debitCardInfo.getCode() == SysResponseEnum.FAILED.getCode()) {
                    responseData.setCode(SysResponseEnum.FAILED.getCode());
                    responseData.setMessage("\u67e5\u8be2\u50a8\u84c4\u5361\u5f02\u5e38");
                    return responseData;
                }
                List cardInfoList = (List)debitCardInfo.getData();
                CusUrRechargeCardPO cardInfo = (CusUrRechargeCardPO)cardInfoList.get(0);
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
                if (cardInfo.getLateRechargeDate() != null) {
                    if (!fmt.format(cardInfo.getLateRechargeDate()).equals(fmt.format(new Date()))) {
                        cardInfo.setOnDayRechargeAmount(new BigDecimal("0"));
                    }
                    if (cardInfo.getOnDayRechargeAmount().add(money).compareTo(configData.getEveryDayLimitAmount()) > 0) {
                        responseData.setCode(SysResponseEnum.FAILED.getCode());
                        responseData.setMessage("\u4e3a\u4e86\u60a8\u7684\u8d44\u91d1\u5b89\u5168\uff0c\u6bcf\u4eba\u6bcf\u5929\u9650\u5145\u503c" + configData.getEveryDayLimitAmount() + "\uff0c\u8c22\u8c22");
                        return responseData;
                    }
                }
            }
        }
        logger.info("\u5145\u503c\u5165\u53c2={} , openId={} , appId={}", new Object[]{vo.toString(), openId, appId});
        Map map = this.wxPayService.createRecharge(vo, wxConfig);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)map);
        return responseData;
    }

    @ApiOperation(value="\u521b\u5efa\u5145\u503c\u5355 --\u65b0", notes="\u521b\u5efa\u5145\u503c\u5355")
    @PostMapping(value={"/createRechargeNew"})
    public ResponseData createRechargeNew(CreateRechargeVO vo, HttpServletRequest request) {
        logger.info("createRecharge pararm:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        ResponseData responseData = new ResponseData();
        String sign = vo.getSign();
        vo.setSign(null);
        String params = JSONObject.toJSONString((Object)vo);
        logger.info("createRechargeNew params:{}", (Object)(params + this.paySalt));
        String check = MD5Util.md5((String)(params + this.paySalt)).toUpperCase();
        logger.info("createRechargeNew check:{}", (Object)check);
        if (!sign.equals(check)) {
            responseData.setMessage("\u6076\u610f\u8bbf\u95ee");
            responseData.setCode(100);
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("bizvaneSessionId\u6ca1\u6709");
            responseData.setCode(100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        if ("0".equals(vo.getMoney()) || StringUtils.isBlank((CharSequence)vo.getMoney())) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u6b63\u786e\u91d1\u989d");
            responseData.setCode(100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel model = (MemberInfoModel)singleMemberModel.getData();
        if (model == null) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        WxPayConfigPo po = new WxPayConfigPo();
        po.setSysCompanyId(model.getSysCompanyId());
        po.setSysBrandId(model.getBrandId());
        String[] brands = this.unionPayBrands.split(",");
        if (Arrays.asList(brands).contains(String.valueOf(model.getBrandId()))) {
            return this.unionPayService.transit(vo, request);
        }
        ResponseData data = this.mbrRechargeServiceRpc.getWxPayConfigRpc(po);
        WxPayConfigPo wxConfig = (WxPayConfigPo)data.getData();
        if (wxConfig == null) {
            responseData.setMessage("\u5546\u6237\u4e0d\u5b58\u5728");
            responseData.setCode(100);
            return responseData;
        }
        String appId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        if (StringUtils.isBlank((CharSequence)vo.getOpenid()) || "null".equals(vo.getOpenid())) {
            String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
            vo.setOpenid(openId);
        }
        vo.setAppId(appId);
        vo.setMemberCode(memberCode);
        if (this.brandId.equals(wxConfig.getSysBrandId())) {
            CusUrRechargeCardPO cardPO;
            CusUrRechargeCardPO rechargeCardPO = CusUrRechargeCardPO.builder().sysBrandId(wxConfig.getSysBrandId()).sysCompanyId(wxConfig.getSysCompanyId()).memberCode(memberCode).build();
            ResponseData debitCardInfo = this.rechargeCardServiceFeign.queryDebitCardInfo(rechargeCardPO);
            if (CollectionUtils.isNotEmpty((Collection)((Collection)debitCardInfo.getData())) && (cardPO = (CusUrRechargeCardPO)((List)debitCardInfo.getData()).get(0)).getCardStatus() == 0) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u60a8\u6709\u4e00\u7b14\u9000\u6b3e\u6d41\u7a0b\u6b63\u5728\u5ba1\u6838\u4e2d");
                return responseData;
            }
            ResponseData rechargeConfig = this.rechargeCardServiceFeign.getRechargeConfig(wxConfig.getSysCompanyId(), wxConfig.getSysBrandId());
            if (rechargeConfig.getData() == null || rechargeConfig.getCode() == SysResponseEnum.FAILED.getCode()) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u67e5\u8be2\u50a8\u84c4\u914d\u7f6e\u5f02\u5e38");
                return responseData;
            }
            CusUrRechargeConfigVO configData = (CusUrRechargeConfigVO)rechargeConfig.getData();
            if (StringUtils.isNotBlank((CharSequence)configData.getRechargeJson())) {
                String rechargeJson = configData.getRechargeJson();
                List giveList = JSONObject.parseArray((String)rechargeJson, CusUrRechargeGiveVO.class);
                giveList.forEach(rechargeInfo -> {
                    if (rechargeInfo.getAmount().equals(Long.valueOf(vo.getMoney()))) {
                        vo.setGiveMoney(String.valueOf(rechargeInfo.getGiveAmount()));
                    }
                });
            }
            logger.info("ur vo:{}", JSON.toJSON((Object)vo));
            BigDecimal money = new BigDecimal(vo.getMoney());
            BigDecimal giveMoney = new BigDecimal(vo.getGiveMoney());
            BigDecimal giveLimitAmount = configData.getGiveLimitAmount().multiply(new BigDecimal("10000"));
            if (configData.getGiveAmount().add(giveMoney).compareTo(giveLimitAmount) > 0) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u5f53\u524d\u5145\u503c\u989d\u5ea6\u5df2\u8d85\u9650\u989d\uff0c\u6682\u4e0d\u652f\u6301\u5145\u503c\u3002\u5982\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5ba2\u670d4006-513-512");
                return responseData;
            }
            if (configData.getEveryDayLimit() == 1 && CollectionUtils.isNotEmpty((Collection)((Collection)debitCardInfo.getData()))) {
                if (debitCardInfo.getCode() == SysResponseEnum.FAILED.getCode()) {
                    responseData.setCode(SysResponseEnum.FAILED.getCode());
                    responseData.setMessage("\u67e5\u8be2\u50a8\u84c4\u5361\u5f02\u5e38");
                    return responseData;
                }
                List cardInfoList = (List)debitCardInfo.getData();
                CusUrRechargeCardPO cardInfo = (CusUrRechargeCardPO)cardInfoList.get(0);
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
                if (cardInfo.getLateRechargeDate() != null) {
                    if (!fmt.format(cardInfo.getLateRechargeDate()).equals(fmt.format(new Date()))) {
                        cardInfo.setOnDayRechargeAmount(new BigDecimal("0"));
                    }
                    if (cardInfo.getOnDayRechargeAmount().add(money).compareTo(configData.getEveryDayLimitAmount()) > 0) {
                        responseData.setCode(SysResponseEnum.FAILED.getCode());
                        responseData.setMessage("\u4e3a\u4e86\u60a8\u7684\u8d44\u91d1\u5b89\u5168\uff0c\u6bcf\u4eba\u6bcf\u5929\u9650\u5145\u503c" + configData.getEveryDayLimitAmount() + "\uff0c\u8c22\u8c22");
                        return responseData;
                    }
                }
            }
        }
        logger.info("\u5145\u503c\u5165\u53c2={} , openId={} , appId={}", new Object[]{vo.toString(), vo.getOpenid(), appId});
        Map map = this.wxPayService.createRecharge(vo, wxConfig);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)map);
        return responseData;
    }

    @ApiOperation(value="\u521b\u5efa\u793c\u54c1\u5361\u8ba2\u5355", notes="\u521b\u5efa\u793c\u54c1\u5361\u8ba2\u5355")
    @PostMapping(value={"/createGiftCardOrder"})
    public ResponseData createGiftCardOrder(@RequestBody CreateGitfCardOrderVo vo, HttpServletRequest request) {
        logger.info("createGiftCardOrder pararm:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        ResponseData responseData = new ResponseData();
        if (StringUtils.isEmpty((CharSequence)request.getHeader("authorizationSign"))) {
            responseData.setMessage("\u975e\u6cd5\u8bf7\u6c42");
            responseData.setCode(-100);
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("bizvaneSessionId\u6ca1\u6709");
            responseData.setCode(100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel model = (MemberInfoModel)singleMemberModel.getData();
        if (model == null) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        WxPayConfigPo po = new WxPayConfigPo();
        po.setSysCompanyId(model.getSysCompanyId());
        po.setSysBrandId(model.getBrandId());
        ResponseData data = this.mbrRechargeServiceRpc.getWxPayConfigRpc(po);
        WxPayConfigPo wxConfig = (WxPayConfigPo)data.getData();
        if (wxConfig == null) {
            responseData.setMessage("\u5546\u6237\u4e0d\u5b58\u5728");
            responseData.setCode(100);
            return responseData;
        }
        String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
        String appId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        vo.setOpenid(openId);
        vo.setAppId(appId);
        vo.setMemberCode(memberCode);
        logger.info("\u5145\u503c\u5165\u53c2={} , openId={} , appId={}", new Object[]{vo.toString(), openId, appId});
        ReqGiftCardInfoDTO dto = new ReqGiftCardInfoDTO();
        dto.setCardGiftDefinitionId(Long.valueOf(Long.parseLong(vo.getServiceCardDefinitionId())));
        dto.setMemberCode(vo.getMemberCode());
        dto.setSysBrandId(vo.getSysBrandId());
        dto.setSysCompanyId(vo.getSysCompanyId());
        dto.setMemberName(model.getName());
        dto.setMomberPhone(model.getPhone());
        ResponseData gitfRes = this.giftCardStandardServiceFeign.saveCreateOrder(dto);
        log.info("\u8bf7\u6c42service-card\u521b\u5efa\u8ba2\u5355res:{}", (Object)JSON.toJSONString((Object)gitfRes));
        if (gitfRes.getCode() != 0 || StringUtils.isEmpty((CharSequence)((CharSequence)gitfRes.getData()))) {
            responseData.setCode(-1);
            responseData.setMessage("\u793c\u54c1\u5361\u670d\u52a1\u5f02\u5e38");
            return responseData;
        }
        JSONObject jsonObject = JSON.parseObject((String)((String)gitfRes.getData()));
        Long giftCardId = jsonObject.getLong("giftCardId");
        vo.setGiftCardId(giftCardId);
        vo.setSellPrice(jsonObject.getInteger("totalFee"));
        Map map = this.wxPayService.createGiftCardOrder(vo, wxConfig);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)map);
        return responseData;
    }

    @ApiOperation(value="\u521b\u5efa\u5145\u503c\u5355 --\u65b0", notes="\u521b\u5efa\u5145\u503c\u5355")
    @PostMapping(value={"/createIntegralRechargeOrder"})
    public ResponseData createIntegralRechargeOrder(CreateRechargeVO vo, HttpServletRequest request) {
        logger.info("createIntegralRechargeOrder pararm:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        ResponseData responseData = new ResponseData();
        String sign = vo.getSign();
        vo.setSign(null);
        String params = JSONObject.toJSONString((Object)vo);
        logger.info("createIntegralRechargeOrder params:{}", (Object)(params + this.paySalt));
        String check = MD5Util.md5((String)(params + this.paySalt)).toUpperCase();
        logger.info("createIntegralRechargeOrder check:{}", (Object)check);
        if (!sign.equals(check)) {
            responseData.setMessage("\u6076\u610f\u8bbf\u95ee");
            responseData.setCode(100);
            return responseData;
        }
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("bizvaneSessionId\u6ca1\u6709");
            responseData.setCode(100);
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        if (vo.getSysBrandId() == null) {
            responseData.setMessage("\u4ff1\u4e50\u90e8\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        if ("0".equals(vo.getMoney()) || StringUtils.isBlank((CharSequence)vo.getMoney())) {
            responseData.setMessage("\u8bf7\u8f93\u5165\u6b63\u786e\u91d1\u989d");
            responseData.setCode(100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setGroupMemberCode(memberCode);
        memberInfoModel.setBrandId(vo.getSysBrandId());
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel model = (MemberInfoModel)singleMemberModel.getData();
        if (model == null) {
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e22\u5931");
            responseData.setCode(-100);
            return responseData;
        }
        WxPayConfigPo po = new WxPayConfigPo();
        po.setSysCompanyId(model.getSysCompanyId());
        po.setSysBrandId(model.getBrandId());
        String[] brands = this.unionPayBrands.split(",");
        if (Arrays.asList(brands).contains(String.valueOf(model.getBrandId()))) {
            return this.unionPayService.transit(vo, request);
        }
        WxPayConfigPo wxConfig = this.getIntegralRechargePayConfig(model);
        if (wxConfig == null) {
            responseData.setMessage("\u5546\u6237\u4e0d\u5b58\u5728");
            responseData.setCode(100);
            return responseData;
        }
        String appId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getAppId" + bizvaneSessionId));
        if (StringUtils.isBlank((CharSequence)vo.getOpenid()) || "null".equals(vo.getOpenid())) {
            String openId = (String)this.redisTemplateService.stringGetStringByKey((Object)("getOpenId" + bizvaneSessionId));
            vo.setOpenid(openId);
        }
        vo.setAppId(appId);
        vo.setMemberCode(memberCode);
        logger.info("\u79ef\u5206\u5145\u503c\u5165\u53c2={} , openId={} , appId={}", new Object[]{vo.toString(), vo.getOpenid(), appId});
        Map map = this.wxPayService.createIntegralRecharge(vo, wxConfig);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)map);
        return responseData;
    }

    private WxPayConfigPo getIntegralRechargePayConfig(MemberInfoModel model) {
        Long sysCompanyId = model.getSysCompanyId();
        ResponseData companyResponseData = this.brandServiceRpc.getBrandListByCompanyId(sysCompanyId);
        logger.info("brandServiceRpc.getBrandListByCompanyId:{}", (Object)JSON.toJSONString((Object)companyResponseData));
        List brandPos = (List)companyResponseData.getData();
        if (companyResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || brandPos == null) {
            return null;
        }
        SysBrandPo masterSysBrandPo = brandPos.stream().filter(sysBrandPo -> sysBrandPo.getMasterCard()).findFirst().orElse(null);
        if (masterSysBrandPo == null) {
            logger.info("masterSysBrandPo is null");
            return null;
        }
        Long masterSysBrandPoSysBrandId = masterSysBrandPo.getSysBrandId();
        WxPayConfigPo payConfig = this.integrationShopService.getPayConfig(Integer.valueOf(masterSysBrandPoSysBrandId.intValue()));
        if (payConfig != null) {
            payConfig.setSysCompanyId(sysCompanyId);
        }
        return payConfig;
    }

    @PostMapping(value={"/callback"})
    public String callback(HttpServletRequest req, HttpServletResponse res) {
        return this.wxPayService.callback(req, res);
    }

    public static void main(String[] args) {
        String s = "{\"appId\":\"wxdbcca5299c27edff\",\"memberCode\":\"f5baf6778a534fad\",\"openid\":\"o19L94yo8F965Yn7okjtsKzYLXPI\",\"serviceCardDefinitionId\":\"240\",\"sysBrandId\":96,\"sysCompanyId\":3841}";
        String check = MD5Util.md5((String)(s + "1qaz2wsx3edc")).toUpperCase();
        System.out.println(check);
    }
}

