/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.bizvane.appletservice.models.bo.PayLevelCardBo;
import com.bizvane.appletservice.models.vo.PayLevelCardShowVo;
import com.bizvane.fitmentservice.models.Rpc.AppletVipCardRpc;
import com.bizvane.fitmentservice.models.vo.AppletPayVipCardRequestVO;
import com.bizvane.fitmentservice.models.vo.AppletPayVipCardResponseVO;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.MemberLevelApiService;
import com.bizvane.members.facade.service.api.MemberLevelRechargeApiService;
import com.bizvane.members.facade.vo.PayLevelCardRequestVO;
import com.bizvane.members.facade.vo.PayLevelCardResponseVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import io.jsonwebtoken.lang.Collections;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/payLevelCard"})
public class PayLevelCardController {
    private static final Logger log = LoggerFactory.getLogger(PayLevelCardController.class);
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private MemberLevelApiService memberLevelApiService;
    @Autowired
    private AppletVipCardRpc appletVipCardRpc;
    @Autowired
    private MemberLevelRechargeApiService memberLevelRechargeApiService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;

    @PostMapping(value={"/getPayLevelCardShow"})
    public ResponseData<PayLevelCardShowVo> getPayLevelCardShow(HttpServletRequest request) {
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        Long sysBrandId = null;
        Long sysCompanyId = null;
        if (StringUtils.isNotBlank((CharSequence)memberCode)) {
            sysBrandId = Long.valueOf(request.getHeader("sysBrandId"));
            sysCompanyId = Long.valueOf(request.getHeader("sysCompanyId"));
        }
        ResponseData responseData = new ResponseData();
        MemberInfoModel searchModel = new MemberInfoModel();
        searchModel.setMemberCode(memberCode);
        searchModel.setSysCompanyId(sysCompanyId);
        searchModel.setBrandId(sysBrandId);
        ResponseData memberResponse = this.memberInfoApiService.getSingleMemberModel(searchModel);
        if (memberResponse == null || memberResponse.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u67e5\u8be2\u4f1a\u5458\u72b6\u6001\u5931\u8d25");
            return responseData;
        }
        MemberInfoModel member = (MemberInfoModel)memberResponse.getData();
        PayLevelCardRequestVO payLevelCardRequestVO = new PayLevelCardRequestVO();
        payLevelCardRequestVO.setSysCompanyId(sysCompanyId);
        payLevelCardRequestVO.setBrandId(sysBrandId);
        ResponseData payLevelCardResponseVOResponseData = this.memberLevelApiService.queryPayLevelCard(payLevelCardRequestVO);
        if (payLevelCardResponseVOResponseData == null || SysResponseEnum.SUCCESS.getCode() != payLevelCardResponseVOResponseData.getCode()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u67e5\u8be2\u4ed8\u8d39\u5361\u4fe1\u606f\u5931\u8d25");
            return responseData;
        }
        PayLevelCardResponseVO payLevelCardResponseVO = (PayLevelCardResponseVO)payLevelCardResponseVOResponseData.getData();
        if (payLevelCardResponseVO == null || Collections.isEmpty((Collection)payLevelCardResponseVO.getPayLevelCardBos())) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage("\u65e0\u4ed8\u8d39\u5361\u4fe1\u606f");
            return responseData;
        }
        List mbrLevelIds = payLevelCardResponseVO.getPayLevelCardBos().stream().map(x -> x.getMbrLevelId()).collect(Collectors.toList());
        AppletPayVipCardRequestVO appletPayVipCardRequestVO = new AppletPayVipCardRequestVO();
        appletPayVipCardRequestVO.setSysCompanyId(sysCompanyId);
        appletPayVipCardRequestVO.setSysBrandId(sysBrandId);
        appletPayVipCardRequestVO.setGradeIdList(mbrLevelIds);
        ResponseData cardResponseData = this.appletVipCardRpc.queryAppletPayVipCard(appletPayVipCardRequestVO);
        if (cardResponseData == null || cardResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u67e5\u8be2\u4ed8\u8d39\u5361\u8be6\u60c5\u5931\u8d25");
            return responseData;
        }
        Map map = ((List)cardResponseData.getData()).stream().collect(Collectors.toMap(AppletPayVipCardResponseVO::getGradeId, Function.identity()));
        Long payLevel = null;
        if (mbrLevelIds.contains(member.getLevelId())) {
            log.info("\u5f53\u524d\u4f1a\u5458\u662f\u4ed8\u8d39\u5361\u7b49\u7ea7");
            payLevel = member.getLevelId();
        }
        Map payLevelCardBoMap = payLevelCardResponseVO.getPayLevelCardBos().stream().collect(Collectors.toMap(com.bizvane.members.facade.models.bo.PayLevelCardBo::getMbrLevelId, Function.identity()));
        Long finalPayLevel = payLevel;
        List payLevelCardBoList = mbrLevelIds.stream().map(level -> {
            PayLevelCardBo payLevelCardBo = new PayLevelCardBo();
            payLevelCardBo.setMbrLevelId(level);
            payLevelCardBo.setLevelName(((com.bizvane.members.facade.models.bo.PayLevelCardBo)payLevelCardBoMap.get(level)).getLevelName());
            AppletPayVipCardResponseVO vipCardResponseVO = (AppletPayVipCardResponseVO)map.get(level);
            payLevelCardBo.setSlogan(vipCardResponseVO != null ? vipCardResponseVO.getSlogan() : null);
            payLevelCardBo.setDescription(vipCardResponseVO != null ? vipCardResponseVO.getDescription() : null);
            if (finalPayLevel == null) {
                payLevelCardBo.setStatus(Integer.valueOf(0));
            } else if (level.equals(finalPayLevel)) {
                payLevelCardBo.setStatus(Integer.valueOf(1));
            } else {
                payLevelCardBo.setStatus(Integer.valueOf(2));
            }
            return payLevelCardBo;
        }).collect(Collectors.toList());
        PayLevelCardShowVo payLevelCardShowVo = new PayLevelCardShowVo();
        payLevelCardShowVo.setPayLevelCardBos(payLevelCardBoList);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)payLevelCardShowVo);
        return responseData;
    }
}

