/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletserviceimpl.controllers;

import com.bizvane.appletservice.interfaces.IntegralExchangeService;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.qywxapi.CompanyIntegralApiService;
import com.bizvane.members.facade.vo.qywx.JudgeYZMemberRequestVo;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.responseinfo.ResponseData;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/integralExchange"})
public class IntegralExchangeController {
    private static final Logger log = LoggerFactory.getLogger(IntegralExchangeController.class);
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private IntegralExchangeService integralExchangeService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private CompanyIntegralApiService companyIntegralApiService;

    @PostMapping(value={"/query"})
    public ResponseData query(HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel member = (MemberInfoModel)singleMemberModel.getData();
        return this.integralExchangeService.query(member.getBrandId(), member.getSysCompanyId(), memberCode);
    }

    @PostMapping(value={"/exchangeDetail"})
    public ResponseData exchangeDetail(Integer exchangeCounts, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel member = (MemberInfoModel)singleMemberModel.getData();
        return this.integralExchangeService.exchangeDetail(exchangeCounts, member.getBrandId(), member.getSysCompanyId());
    }

    @PostMapping(value={"/confirmExchange"})
    public ResponseData confirmExchange(HttpServletRequest request, Integer exchangeCounts) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        if (memberCode == null) {
            responseData.setMessage("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            responseData.setCode(-100);
            return responseData;
        }
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel member = (MemberInfoModel)singleMemberModel.getData();
        log.info("\u5151\u6362\u79ef\u5206{},\u4f1a\u5458\u53ef\u7528\u79ef\u5206{}", (Object)exchangeCounts, (Object)member.getCountIntegral());
        if (exchangeCounts.compareTo(member.getCountIntegral()) == 1) {
            responseData.setMessage("\u60a8\u7684\u79ef\u5206\u597d\u50cf\u4e0d\u591f\u4e86\u54e6");
            responseData.setCode(101);
            return responseData;
        }
        return this.integralExchangeService.confirmExchange(memberCode, member.getSysCompanyId(), member.getBrandId(), exchangeCounts);
    }

    @PostMapping(value={"/judegYZMember"})
    public ResponseData judegYzMember(Integer exchangeCounts, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        String bizvaneSessionId = request.getHeader("bizvaneSessionId");
        if (bizvaneSessionId == null) {
            responseData.setMessage("\u7cfb\u7edf\u5df2\u5347\u7ea7\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
            return responseData;
        }
        String memberCode = (String)this.redisTemplateService.stringGetStringByKey((Object)(bizvaneSessionId + "memberCode"));
        JudgeYZMemberRequestVo judgeYzMemberRequestVo = new JudgeYZMemberRequestVo();
        judgeYzMemberRequestVo.setMemberCode(memberCode);
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setMemberCode(memberCode);
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
        MemberInfoModel member = (MemberInfoModel)singleMemberModel.getData();
        judgeYzMemberRequestVo.setSysCompanyId(member.getSysCompanyId());
        judgeYzMemberRequestVo.setBrandId(member.getBrandId());
        return this.companyIntegralApiService.judegYZMember(judgeYzMemberRequestVo);
    }
}

