/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.appletservice.utils;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.models.vo.UpgradeAmountVO;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.bo.PayLevelCardBo;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MathUtils {
    private static final Logger log = LoggerFactory.getLogger(MathUtils.class);

    public static UpgradeAmountVO calculateUpgradeAmount(PayLevelCardBo cardA, PayLevelCardBo cardB, Date effectiveTime) {
        log.info("\u5f00\u59cb\u8ba1\u7b97\u4f1a\u5458\u5347\u7ea7\u8d39\u7528,A\u5361\uff1a{}\uff0cB\u5361\uff1a{}\uff0c\u5f00\u5361\u65f6\u95f4\uff1a{}\uff0c\u5230\u671f\u65f6\u95f4\uff1a{}", new Object[]{JSONObject.toJSONString((Object)cardA), JSONObject.toJSONString((Object)cardB), effectiveTime});
        UpgradeAmountVO amountVO = MathUtils.calculateUpgradeAmount(cardA.getPayMoney(), cardB.getPayMoney(), cardA.getEffectiveYear(), effectiveTime);
        if (amountVO != null) {
            amountVO.setCardAName(cardA.getLevelName());
            amountVO.setCardBName(cardB.getLevelName());
        }
        return amountVO;
    }

    public static UpgradeAmountVO calculateUpgradeAmount(MbrLevelModel cardA, MbrLevelModel cardB, Date effectiveTime) {
        log.info("\u8ba1\u7b97\u4f1a\u5458\u5347\u7ea7\u8d39\u7528,A\u5361\uff1a{}\uff0cB\u5361\uff1a{}\uff0c\u5230\u671f\u65f6\u95f4\uff1a{}", new Object[]{JSONObject.toJSONString((Object)cardA), JSONObject.toJSONString((Object)cardB), effectiveTime});
        UpgradeAmountVO amountVO = MathUtils.calculateUpgradeAmount(cardA.getPayMoney(), cardB.getPayMoney(), cardA.getEffectiveYear(), effectiveTime);
        if (amountVO != null) {
            amountVO.setCardAName(cardA.getLevelName());
            amountVO.setCardBName(cardB.getLevelName());
        }
        return amountVO;
    }

    public static UpgradeAmountVO calculateUpgradeAmount(BigDecimal payMoney, MbrLevelModel cardA, MbrLevelModel cardB, Date effectiveTime) {
        log.info("\u8ba1\u7b97\u4f1a\u5458\u5347\u7ea7\u8d39\u7528,A\u5361\uff1a{}\uff0cB\u5361\uff1a{}\uff0c\u5230\u671f\u65f6\u95f4\uff1a{}", new Object[]{JSONObject.toJSONString((Object)cardA), JSONObject.toJSONString((Object)cardB), effectiveTime});
        UpgradeAmountVO amountVO = MathUtils.calculateUpgradeAmount(payMoney, cardB.getPayMoney(), cardA.getEffectiveYear(), effectiveTime);
        if (amountVO != null) {
            amountVO.setCardAName(cardA.getLevelName());
            amountVO.setCardBName(cardB.getLevelName());
        }
        return amountVO;
    }

    public static void main(String[] args) {
        Date effectiveTime = new Date(1892450608000L);
        UpgradeAmountVO amountVO = MathUtils.calculateUpgradeAmount(new BigDecimal(66.0), new BigDecimal(99.0), 5, effectiveTime);
        log.info("\u5347\u7ea7\u8d39\u7528\u8ba1\u7b97\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)amountVO));
    }

    public static UpgradeAmountVO calculateUpgradeAmount(BigDecimal payMoneyA, BigDecimal payMoneyB, Integer effectiveYear, Date effectiveTime) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(effectiveTime);
            cal.add(1, -effectiveYear.intValue());
            Date openCardTime = cal.getTime();
            long totalDays = (effectiveTime.getTime() - openCardTime.getTime()) / 86400000L;
            long usedDays = (new Date().getTime() - openCardTime.getTime()) / 86400000L;
            long remainingDays = totalDays - usedDays;
            BigDecimal unusedAmountA = payMoneyA.divide(new BigDecimal(totalDays), 10, 4).multiply(new BigDecimal(remainingDays)).setScale(2, 4);
            BigDecimal dailyCostB = payMoneyB.divide(new BigDecimal(totalDays), 2, 4);
            BigDecimal upgradeAmount = payMoneyB.divide(new BigDecimal(totalDays), 10, 4).multiply(new BigDecimal(remainingDays)).subtract(unusedAmountA).setScale(2, 4);
            log.info("\u5347\u7ea7\u8d39\u7528\u8ba1\u7b97\uff1aA\u5361\uff0c\u603b\u6709\u6548\u5929\u6570\uff1a{}\uff0cA\u5361\u8d2d\u4e70\u91d1\u989d\uff1a{}\uff0c\u5f00\u5361\u65f6\u95f4\uff1a{}\uff0c\u5230\u671f\u65f6\u95f4\uff1a{}\uff0c\u5269\u4f59\u5929\u6570\uff1a{}\uff0cA\u5361\u672a\u4f7f\u7528\u7684\u91d1\u989d\uff1a{}", new Object[]{totalDays, payMoneyA, openCardTime, effectiveTime, remainingDays, unusedAmountA});
            log.info("\u5347\u7ea7\u8d39\u7528\u8ba1\u7b97\uff1aB\u5361\uff0cB\u5361\u8d2d\u4e70\u91d1\u989d\uff1a{}\uff0cB\u5361\u6bcf\u65e5\u4f7f\u7528\u6210\u672c\uff1a{}\uff0c\u5347\u7ea7\u6240\u9700\u652f\u4ed8\u7684\u91d1\u989d\uff1a{}", new Object[]{payMoneyB, dailyCostB, upgradeAmount});
            return UpgradeAmountVO.builder().totalDays(totalDays).payMoneyA(payMoneyA).usedDays(usedDays).remainingDays(remainingDays).unusedAmountA(unusedAmountA).payMoneyB(payMoneyB).dailyCostB(dailyCostB).upgradeAmount(upgradeAmount).build();
        }
        catch (Exception e) {
            log.error("\u8ba1\u7b97\u5347\u7ea7\u8d39\u7528\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }
}

