package com.bizvane.appletservice.models.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.List;

/**
 * 商品
 *
 * @author gs
 * @date 2019/3/18
 */
@Data
@ToString
public class ShopStoreVo {
    private String ShopId;
    //商品名称
    private String goodsNo;
    //积分
    private String price;
    private String goodsName;
    //上架时间
    private String upperShelfTime;
    //商品图片
    private String coverImg;
    private List<String> bannerImgPaths;
    private String classifyId;
    //兑换数量
    private String actualSales;
    //限对数量
    private String restrictedNum;
    private String shelf;
    private String hot;
    private String distributionMode;
    private String goodsDetails;
    private List<ShopStoreSkuVo> shopStoreSkuVos;
    private List<ShopClassifyMapVo> classifyMapVos;
    private ShopVo shopVo;
    private String exchangeInstructions;
    private Integer exchangeStatus;
    private Integer exchangeCount;
    private Integer isWholeStore;
    //商品总库存
    private Integer totalStock;
    //积分商城商品类型
    private Integer goodsType;

    private Integer priceType;

    private String cashPrice;

    private Integer templateId;

    private Integer freightType;

    private BigDecimal defaultFreight;

    private Integer showChargeNo;

    @ApiModelProperty(name = "exchangeJumpStatus",value = "是否开启兑换跳转：true-开启，false-关闭")
    private Boolean exchangeJumpStatus = Boolean.FALSE;

    @ApiModelProperty(name = "exchangeJumpAppId",value = "兑换后跳转微信小程序appid")
    private String exchangeJumpAppId;

    @ApiModelProperty(name = "exchangeJumpAppName",value = "兑换后跳转微信小程序名称")
    private String exchangeJumpAppName;

    @ApiModelProperty(name = "exchangeJumpAppPage",value = "兑换后跳转小程序页面")
    private String exchangeJumpAppPage;

    @ApiModelProperty(name = "exchangeJumpButtonName",value = "兑换后跳转按钮名称")
    private String exchangeJumpButtonName;

    @ApiModelProperty(name = "isSetZitiStore",value = "是否独立设置自提门店")
    private Boolean isSetZitiStore;
    @ApiModelProperty(name = "exchangeJumpButtonName",value = "自提门店类型：0-全部，1-部分门店，2-服务门店")
    private Integer zitiStoreType;
    @ApiModelProperty(name = "zitiStoreList",value = "自提门店列表")
    private String zitiStoreList;

}
