package com.bizvane.appletservice.interfaces;

import com.bizvane.appletservice.models.vo.ActivityCommonRequestVO;
import com.bizvane.mktcenterservice.models.po.MktActivityPrizeRecordPO;
import com.bizvane.mktcenterservice.models.vo.ActivityPrizeBO;
import com.bizvane.mktcenterservice.models.vo.ActivityPrizeRecordDetailBO;
import com.bizvane.mktcenterservice.models.vo.LotteryRecordCommonRequestVO;
import com.bizvane.mktcenterservice.models.vo.mktp.PrizeRecordCommonRequestVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatenterprise.service.entity.vo.WxqyOpengidToGroupChatIdRequestVO;
import com.bizvane.wechatenterprise.service.entity.vo.WxqyOpengidToGroupChatIdResponseVO;

import java.text.ParseException;
import java.util.List;

/**
 * 抽奖
 *
 * @author gs
 */
public interface MemberLotteryService {
    /**
     * 抽奖活动记录
     *
     * @param
     * @return
     */
    @Deprecated
    ResponseData<List<MktActivityPrizeRecordPO>> winningRecord(MktActivityPrizeRecordPO mktActivityPrizeRecordPO);

    /**
     * 抽奖活动记录,返回奖项图片
     * @param requestVO
     * @return
     */
    ResponseData winningRecordNew(PrizeRecordCommonRequestVO requestVO);
    /**
     * 抽奖活动规则
     *
     * @param
     * @return
     */
    ResponseData<ActivityPrizeBO> activityRules(String activePriceCode);

    /**
     * 抽奖活动规则
     *
     * @param
     * @return
     */
    ResponseData activityRulesNew(ActivityCommonRequestVO activityCommonRequestVO);

    /**
     * 抽奖动作
     *
     * @param
     * @return
     */
    ResponseData lotteryDoIng(String activePriceCode, String memberCode, Long clientBaseInfoId);

    /**
     * 积分获取途径说明
     *
     * @param
     * @return
     */
    ResponseData<ActivityPrizeBO> theWayToAcquireIntegral(String activePriceCode);

    /**
     * 抽奖首页
     *
     * @param
     * @return
     */
    ResponseData<ActivityPrizeBO> luckDraw(String activePriceCode, String memberCode) throws ParseException;

    /**
     * 轮播图
     *
     * @param
     * @return
     */
    ResponseData<List<MktActivityPrizeRecordPO>> rotation(MktActivityPrizeRecordPO mktActivityPrizeRecordPO);

    /**
     * 我的积分
     *
     * @param
     * @return
     */
    ResponseData countIntegral(String memberCode);

    /**
     * 公共判断活动范围
     *
     * @param
     * @return
     */
    ResponseData scanningLottery(String memberCode, String activityCode);

    /**
     * 实物中奖新增收货地址
     *
     * @param
     * @return
     */
    void addressLotteryRecord(MktActivityPrizeRecordPO mktActivityPrizeRecordPO);

    /**
     * 实物配置物流地址或者自提门店code
     *
     * @param
     * @return
     */
    ResponseData addressLotteryRecordNew(LotteryRecordCommonRequestVO requestVO);

    /**
     * 根据中奖ID获取详情
     * @param requestVO
     * @return
     */
    ResponseData<ActivityPrizeRecordDetailBO> winningRecordDetail(PrizeRecordCommonRequestVO requestVO);

    /**
     * 获取会员该游戏赠送次数
     * @param sysBrandId
     * @param activityCode
     * @param memberCode
     * @return
     */
    ResponseData selectGivenGameNum(Long sysBrandId, String activityCode, String memberCode);

    /**
     * 判断任务范围(目前只支持邀请开卡和调查问卷)
     * @param memberCode
     * @param taskId
     * @param taskType  3-邀请开卡，6-调查问卷
     * @return
     */
    ResponseData taskScanningLottery(String memberCode, Long taskId, Integer taskType);

    ResponseData<WxqyOpengidToGroupChatIdResponseVO> checkAndGetActivityGroupChatId(WxqyOpengidToGroupChatIdRequestVO requestVO);
}
