package com.bizvane.ajhfacade.rpc;
import com.bizvane.ajhfacade.models.po.Comments;
import com.bizvane.ajhfacade.models.po.Orders;
import com.bizvane.ajhfacade.models.po.Project;
import com.bizvane.ajhfacade.po.Aftersales;
import com.bizvane.ajhfacade.vo.InstallVO;
import com.bizvane.ajhfacade.vo.OrdersVO;
import com.bizvane.ajhfacade.vo.PurchasedProductsVO;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import java.util.List;
@FeignClient(value = "${feign.client.ajh.name}", path = "${feign.client.ajh.path}/ordersRpc")
public interface OdersRpcService {

     @RequestMapping(value = "/getOrdersListRpc", method = RequestMethod.POST)
     ResponseData<PageInfo>  selectAftermarket(@RequestBody  InstallVO installVO);

     @RequestMapping(value = "/insert",method = RequestMethod.POST)
     ResponseData  insert(@RequestBody Comments comments);

     @RequestMapping(value = "/updateCancel",method = RequestMethod.POST)
     ResponseData userCancel(@RequestBody Orders orders);

     @RequestMapping(value = "/querAllByType",method = RequestMethod.GET)
     ResponseData<List<Project>> querAllByType(@RequestParam("projectType") byte projectType);

     @RequestMapping(value = "/selectViewAudit",method = RequestMethod.GET)
     ResponseData<OrdersVO> selectViewAudit(@RequestParam("id") Integer id);

     @RequestMapping(value = "/selectProducts",method = RequestMethod.POST)
     ResponseData<PageInfo> purchasedProducts(@RequestBody PurchasedProductsVO purchasedProductsVO);

     @RequestMapping(value = "/addOrder",method = RequestMethod.POST)
     ResponseData addOrder(@RequestBody Orders orders);

}