package com.bizvane.ajhfacade.rpc;

import com.bizvane.ajhfacade.models.po.MasterWorker;
import com.bizvane.ajhfacade.models.po.Orders;
import com.bizvane.ajhfacade.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.ajh.name}",path = "${feign.client.ajh.path}/wechatMasterRpc")
public interface WechatMasterRpcService {

    /**
     * 公众号登录获取师傅信息
     *
     * @return
     */
    @RequestMapping(value = "/login", method = RequestMethod.POST)
    ResponseData<MasterWorker> login(@RequestBody MasterLoginVO request);
    /**
     * 获取验证码
     *
     * @return
     */
    @RequestMapping(value = "/getVerifyCode", method = RequestMethod.POST)
    ResponseData<String> getVerifyCode(@RequestBody MasterBindVO request);
    /**
     * 绑定手机号
     *
     * @return
     */
    @RequestMapping(value = "/bind", method = RequestMethod.POST)
    ResponseData<String> bind(@RequestBody MasterBindVO request);
    /**
     * 获取订单列表
     *
     * @return
     */
    @RequestMapping(value = "/getMasterOrderList", method = RequestMethod.POST)
    ResponseData<List<Orders>> getMasterOrderList(@RequestBody MasterOrderVO request);
    /**
     * 更改订单信息
     *
     * @return
     */
    @RequestMapping(value = "/updateOrder", method = RequestMethod.POST)
    ResponseData<String> updateOrder(@RequestBody MasterUpdateOrderVO request);

}
