/*
 * Decompiled with CFR 0.152.
 */
package cn.bizvane.rocketmq.spring.core.producer.stat;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.atomic.AtomicLong;

public class RocketMQSendStats
extends Observable {
    private final Map<Destination, AtomicLong> sendTotalStats = Maps.newConcurrentMap();
    private final Map<Destination, AtomicLong> sendSuccessStats = Maps.newConcurrentMap();
    private final Map<Destination, AtomicLong> sendFailStats = Maps.newConcurrentMap();
    private final Map<Destination, AtomicLong> sendFailRetryStats = Maps.newConcurrentMap();

    public void success(Destination destination) {
        this.increment(destination, this.sendSuccessStats);
    }

    public void fail(Destination destination) {
        this.increment(destination, this.sendFailStats);
    }

    public void failRetry(Destination destination) {
        this.increment(destination, this.sendFailRetryStats);
    }

    public void total(Destination destination) {
        this.increment(destination, this.sendTotalStats);
    }

    public long getTotal(Destination destination) {
        AtomicLong r = this.sendTotalStats.get(destination);
        return r == null ? 0L : r.getAndSet(0L);
    }

    public long getSuccess(Destination destination) {
        AtomicLong r = this.sendSuccessStats.get(destination);
        return r == null ? 0L : r.getAndSet(0L);
    }

    public long getFail(Destination destination) {
        AtomicLong r = this.sendFailStats.get(destination);
        return r == null ? 0L : r.getAndSet(0L);
    }

    private void increment(Destination destination, Map<Destination, AtomicLong> stats) {
        AtomicLong atomicLong = stats.get(destination);
        if (atomicLong == null) {
            atomicLong = new AtomicLong();
            stats.put(destination, atomicLong);
            this.setChanged();
            this.notifyObservers(destination);
        }
        atomicLong.incrementAndGet();
    }
}

