package cn.bizvane.rocketmq.spring.core.consumer;

import cn.bizvane.rocketmq.spring.autoconfigure.RocketMQProperties;

/**
 * @author wang.zeyan
 * 2019/08/28
 */
public enum RetryStrategy {

    /**
     * 重试，直到成功。
     * 如果消费失败，一直重试，直到成功为止。 不受重试次数限制。
     */
    RETRY_UNTIL_SUCCESS,

    /**
     * 重试到最大重试次数, 如果失败， 将跳过这条消息， 该消息将进入 死信队列。
     * {@link RocketMQProperties.ConsumerGroup#maxRetryCount}
     */
    RETRY_MAXIMUM;
}
