package cn.bizvane.rocketmq.spring.core.consumer;

import cn.bizvane.rocketmq.spring.annotation.Orderly;
import cn.bizvane.rocketmq.spring.exception.ConsumerListenerFindException;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.common.message.MessageExt;

import java.util.List;
import java.util.Optional;

/**
 * wang.zeyan 2019/08/20
 */
@Slf4j
public class MessageListenerOrderlyImpl implements MessageListenerOrderly, MessageStatus {

    @Override
    public ConsumeOrderlyStatus consumeMessage(List<MessageExt> msgs, ConsumeOrderlyContext context) {
        final MessageExt messageExt = msgs.get(0);
        ConsumerMessage consumerMessage = null;
        RocketMQListener listener = null;
        try {
            String topic = messageExt.getTopic();
            String tags = messageExt.getTags();
            String status = getStatus(messageExt);

            listener = RocketMQConsumerUtils.getListener(topic, tags);
            if(listener == null) {
                throw new ConsumerListenerFindException(String.format("topic: %s, tags: %s, listener不存在", topic, tags));
            }

            consumerMessage = RocketMQConsumerUtils.convertMessage(messageExt, listener);
            consumerMessage.setStatus(status);
            listener.onMessage(consumerMessage);
            return ConsumeOrderlyStatus.SUCCESS;
        } catch (Exception e) {
            log.error("消费异常", e);
            Optional.ofNullable(listener).ifPresent((l) -> {
                Orderly orderly = l.getClass().getAnnotation(Orderly.class);
                if(orderly.retryStrategy() == RetryStrategy.RETRY_UNTIL_SUCCESS) {
                    // 关闭自动提交
                    context.setAutoCommit(false);
                    // 设置重试为 未成功一直重试, 直到成功位置。 成功后继续消费当前队列消息
                    messageExt.setReconsumeTimes(-1);
                }
                //当次有效
                //context.setSuspendCurrentQueueTimeMillis(10000);
            });
            return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
        } finally {
            setStatus(messageExt, consumerMessage.getStatus());
        }
    }


}
