package cn.bizvane.rocketmq.spring.core.consumer;

import cn.bizvane.rocketmq.spring.exception.ConsumerListenerFindException;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;

import java.util.List;

/**
 * wang.zeyan 2019/08/20
 */
@Slf4j
public class MessageListenerConcurrentlyImpl implements MessageListenerConcurrently, MessageStatus {
    @Override
    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
        final MessageExt messageExt = msgs.get(0);
        ConsumerMessage consumerMessage = null;
        try {
            String topic = messageExt.getTopic();
            String tags = messageExt.getTags();
            String status = getStatus(messageExt);

            RocketMQListener listener = RocketMQConsumerUtils.getListener(topic, tags);

            if(listener == null) {
                throw new ConsumerListenerFindException(String.format("topic: %s, tags: %s, listener不存在", topic, tags));
            }
            consumerMessage = RocketMQConsumerUtils.convertMessage(messageExt, listener);
            consumerMessage.setStatus(status);
            listener.onMessage(consumerMessage);
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        } catch (Exception e) {
            log.error("消费异常", e);
            return ConsumeConcurrentlyStatus.RECONSUME_LATER;
        } finally {
            setStatus(messageExt, consumerMessage.getStatus());
        }
    }
}
