package cn.bizvane.rocketmq.spring.annotation;


import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.springframework.stereotype.Component;

import java.lang.annotation.*;


/**
 * wang.zeyan 2019/08/20
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Component
public @interface RocketMQMessageListener {

    /**
     * 消息主题名称 `,`分割, 如 `topicA`
     */
    String topic();

    /**
     * 消息tag, 未设置为监听所有
     * @return
     */
    String [] tags() default "*";

    /**
     * Consumer Group Name, 默认使用全局group
     * @return
     */
    // String groupName() default "";

    /**
     * 消费重试次数, 默认使用全局配置
     * @return
     */
    //int maxRetryCount() default -1;

    /**
     * 消费超时时间 , 单位： 分钟, 默认使用全局配置
     */
    //long timeout() default -1;

    /**
     * 消费最大线程数, 默认使用全局配置
     * @return
     */
    //int maxThread() default -1;

    /**
     * 消费从何开始
     * @return
     */
    //ConsumeFromWhere consumeFromWhere() default ConsumeFromWhere.CONSUME_FROM_LAST_OFFSET;

    /**
     * 当 ConsumeFromWhere 为 CONSUME_FROM_TIMESTAMP时使用
     * 消息回溯时间, 时间格式:yyyyMMddHHmmss
     * 如 20190828101010 表示为2019年8月28日上午10时10分10秒, 默认回溯时间为 半小时前
     * @return
     */
    //String consumeTimestamp() default "";

}
