/*
 * Decompiled with CFR 0.152.
 */
package cn.bizvane.rocketmq.zipkin.autoconfigure;

import brave.Tracer;
import cn.bizvane.rocketmq.spring.autoconfigure.RocketMQAutoConfiguration;
import cn.bizvane.rocketmq.zipkin.aspect.TraceMqConsumerAspect;
import cn.bizvane.rocketmq.zipkin.aspect.TraceMqProducerAspect;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.producer.MQProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@EnableAspectJAutoProxy
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class, RocketMQAutoConfiguration.class})
public class ZipkinAspectAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ZipkinAspectAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={MQProducer.class})
    public TraceMqProducerAspect traceMqProducerAspect(Tracer tracer) {
        if (log.isDebugEnabled()) {
            log.debug("\u521b\u5efaRocketMq Producer Aspect");
        }
        return new TraceMqProducerAspect(tracer);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={MessageListener.class})
    public TraceMqConsumerAspect traceMqConsumerAspect(Tracer tracer) {
        if (log.isDebugEnabled()) {
            log.debug("\u521b\u5efaRocketMq Consumer Aspect");
        }
        return new TraceMqConsumerAspect(tracer);
    }
}

