/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import redis.clients.jedis.params.Params;

public class ClientKillParams
extends Params {
    private static final String ID = "ID";
    private static final String TYPE = "TYPE";
    private static final String ADDR = "ADDR";
    private static final String SKIPME = "SKIPME";

    public static ClientKillParams clientKillParams() {
        return new ClientKillParams();
    }

    public ClientKillParams id(String clientId) {
        this.addParam(ID, clientId);
        return this;
    }

    public ClientKillParams id(byte[] clientId) {
        this.addParam(ID, clientId);
        return this;
    }

    public ClientKillParams type(Type type) {
        this.addParam(TYPE, (Object)type);
        return this;
    }

    public ClientKillParams addr(String ipPort) {
        this.addParam(ADDR, ipPort);
        return this;
    }

    public ClientKillParams addr(byte[] ipPort) {
        this.addParam(ADDR, ipPort);
        return this;
    }

    public ClientKillParams addr(String ip, int port) {
        this.addParam(ADDR, ip + ':' + port);
        return this;
    }

    public ClientKillParams skipMe(SkipMe skipMe) {
        this.addParam(SKIPME, (Object)skipMe);
        return this;
    }

    public static enum SkipMe {
        YES,
        NO;

    }

    public static enum Type {
        NORMAL,
        MASTER,
        SLAVE,
        PUBSUB;

    }
}

