/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.DBObject;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.util.Assert;

class ExposedFieldsAggregationOperationContext
implements AggregationOperationContext {
    private final ExposedFields exposedFields;
    private final AggregationOperationContext rootContext;

    public ExposedFieldsAggregationOperationContext(ExposedFields exposedFields, AggregationOperationContext rootContext) {
        Assert.notNull((Object)exposedFields, (String)"ExposedFields must not be null!");
        Assert.notNull((Object)rootContext, (String)"RootContext must not be null!");
        this.exposedFields = exposedFields;
        this.rootContext = rootContext;
    }

    @Override
    public DBObject getMappedObject(DBObject dbObject) {
        return this.rootContext.getMappedObject(dbObject);
    }

    @Override
    public ExposedFields.FieldReference getReference(Field field) {
        return this.getReference(field, field.getTarget());
    }

    @Override
    public ExposedFields.FieldReference getReference(String name) {
        return this.getReference(null, name);
    }

    private ExposedFields.FieldReference getReference(Field field, String name) {
        ExposedFields.ExposedField rootField;
        Assert.notNull((Object)name, (String)"Name must not be null!");
        ExposedFields.ExposedField exposedField = this.exposedFields.getField(name);
        if (exposedField != null) {
            if (field != null) {
                return new ExposedFields.FieldReference(new ExposedFields.ExposedField(field, exposedField.isSynthetic()));
            }
            return new ExposedFields.FieldReference(exposedField);
        }
        if (name.contains(".") && (rootField = this.exposedFields.getField(name.split("\\.")[0])) != null) {
            return new ExposedFields.FieldReference(new ExposedFields.ExposedField(name, true));
        }
        throw new IllegalArgumentException(String.format("Invalid reference '%s'!", name));
    }
}

