/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.EnvironmentCleaner;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.NativeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.cloud.config.server.support.AbstractScmAccessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public abstract class AbstractScmEnvironmentRepository
extends AbstractScmAccessor
implements EnvironmentRepository,
SearchPathLocator,
Ordered {
    private EnvironmentCleaner cleaner = new EnvironmentCleaner();
    private int order = Integer.MAX_VALUE;

    public AbstractScmEnvironmentRepository(ConfigurableEnvironment environment) {
        super(environment);
    }

    @Override
    public synchronized Environment findOne(String application, String profile, String label) {
        NativeEnvironmentRepository delegate = new NativeEnvironmentRepository(this.getEnvironment());
        SearchPathLocator.Locations locations = this.getLocations(application, profile, label);
        delegate.setSearchLocations(locations.getLocations());
        Environment result = delegate.findOne(application, profile, "");
        result.setVersion(locations.getVersion());
        result.setLabel(label);
        return this.cleaner.clean(result, this.getWorkingDirectory().toURI().toString(), this.getUri());
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

