/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.instrumentation;

import java.net.URISyntaxException;
import java.net.URL;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.SignatureAttribute;
import org.javalite.instrumentation.InstrumentationException;

public class ModelInstrumentation {
    private CtClass modelClass;

    public ModelInstrumentation() throws NotFoundException {
        ClassPool cp = ClassPool.getDefault();
        cp.insertClassPath((ClassPath)new ClassClassPath(this.getClass()));
        this.modelClass = ClassPool.getDefault().get("org.javalite.activejdbc.Model");
    }

    public void instrument(CtClass modelClass) throws InstrumentationException {
        try {
            this.addDelegates(modelClass);
            CtMethod m = CtNewMethod.make((String)("public static String getClassName() { return \"" + modelClass.getName() + "\"; }"), (CtClass)modelClass);
            CtMethod getClassNameMethod = modelClass.getDeclaredMethod("getClassName");
            modelClass.removeMethod(getClassNameMethod);
            modelClass.addMethod(m);
            String out = this.getOutputDirectory(modelClass);
            System.out.println("Instrumented class: " + modelClass.getName() + " in directory: " + out);
            modelClass.writeFile(out);
        }
        catch (Exception e) {
            throw new InstrumentationException(e);
        }
    }

    private String getOutputDirectory(CtClass modelClass) throws NotFoundException, URISyntaxException {
        URL u = modelClass.getURL();
        String file = u.getFile();
        file = file.substring(0, file.length() - 6);
        String className = modelClass.getName();
        className = className.replace(".", "/");
        return file.substring(0, file.indexOf(className));
    }

    private void addDelegates(CtClass target) throws NotFoundException, CannotCompileException {
        CtMethod[] modelMethods = this.modelClass.getDeclaredMethods();
        CtMethod[] targetMethods = target.getDeclaredMethods();
        for (CtMethod method : modelMethods) {
            if (2 == method.getModifiers()) continue;
            CtMethod newMethod = CtNewMethod.delegator((CtMethod)method, (CtClass)target);
            for (Object attr : method.getMethodInfo().getAttributes()) {
                if (!(attr instanceof SignatureAttribute)) continue;
                SignatureAttribute signatureAttribute = (SignatureAttribute)attr;
                newMethod.getMethodInfo().addAttribute((AttributeInfo)signatureAttribute);
            }
            if (!this.targetHasMethod(targetMethods, newMethod)) {
                target.addMethod(newMethod);
                continue;
            }
            System.out.println("Detected method: " + newMethod.getName() + ", skipping delegate.");
        }
    }

    private void addSerializationSupport(CtClass target) throws CannotCompileException, NotFoundException {
        CtMethod m = CtNewMethod.make((String)"private void writeObject(java.io.ObjectOutputStream out)  {\n        out.writeObject(toMap());\n}", (CtClass)target);
        CtClass ioException = ClassPool.getDefault().get("java.io.IOException");
        CtClass classNotFoundException = ClassPool.getDefault().get("java.lang.ClassNotFoundException");
        m.setExceptionTypes(new CtClass[]{ioException});
        target.addMethod(m);
        m = CtNewMethod.make((String)"private void readObject(java.io.ObjectInputStream in) {\n        fromMap((java.util.Map)in.readObject());\n    }", (CtClass)target);
        m.setExceptionTypes(new CtClass[]{ioException, classNotFoundException});
        target.addMethod(m);
    }

    private CtMethod createFindById(CtClass clazz) throws CannotCompileException {
        String body = "public static " + clazz.getName() + " findById(Object obj)\n" + "        {\n" + "            return (" + clazz.getName() + ")org.javalite.activejdbc.Model.findById(obj);\n" + "        }";
        return CtNewMethod.make((String)body, (CtClass)clazz);
    }

    private CtMethod createFindFirst(CtClass clazz) throws CannotCompileException {
        String body = " public static " + clazz.getName() + " findFirst(String s, Object params[])\n" + "   {\n" + "       return (" + clazz.getName() + ")org.javalite.activejdbc.Model.findFirst(s, params);\n" + "   }";
        return CtNewMethod.make((String)body, (CtClass)clazz);
    }

    private boolean targetHasMethod(CtMethod[] targetMethods, CtMethod delegate) {
        for (CtMethod targetMethod : targetMethods) {
            if (!targetMethod.equals((Object)delegate)) continue;
            return true;
        }
        return false;
    }
}

