/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.instrumentation;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.javalite.instrumentation.InstrumentationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationModelFinder {
    private CtClass modelClass;
    private List<CtClass> models = new ArrayList<CtClass>();
    private String currentDirectoryPath;

    InstrumentationModelFinder() throws NotFoundException, ClassNotFoundException {
        ClassPool pool = ClassPool.getDefault();
        pool.insertClassPath((ClassPath)new ClassClassPath(Class.forName("org.javalite.activejdbc.Association")));
        this.modelClass = pool.get("org.javalite.activejdbc.Model");
    }

    private void processFilePath(File file) {
        try {
            if (file.getCanonicalPath().toLowerCase().endsWith(".jar") || file.getCanonicalPath().toLowerCase().endsWith(".zip")) {
                ZipFile zip = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith("class")) continue;
                    InputStream zin = zip.getInputStream(entry);
                    this.classFound(entry.getName().replace(File.separatorChar, '.').substring(0, entry.getName().length() - 6));
                    zin.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void processDirectoryPath(File directory) throws IOException, ClassNotFoundException {
        this.currentDirectoryPath = directory.getCanonicalPath();
        this.processDirectory(directory);
    }

    private void processDirectory(File directory) throws IOException, ClassNotFoundException {
        this.findFiles(directory);
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                this.processDirectory(file);
            }
        }
    }

    private void findFiles(File directory) throws IOException, ClassNotFoundException {
        File[] files = directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".class");
            }
        });
        if (files != null) {
            for (File file : files) {
                int current = this.currentDirectoryPath.length();
                String fileName = file.getCanonicalPath().substring(++current);
                String className = fileName.replace(File.separatorChar, '.').substring(0, fileName.length() - 6);
                this.classFound(className);
            }
        }
    }

    protected void classFound(String className) throws IOException, ClassNotFoundException {
        try {
            ClassPool cp = ClassPool.getDefault();
            CtClass clazz = cp.get(className);
            if (clazz.subclassOf(this.modelClass) && clazz != null && !clazz.equals(this.modelClass)) {
                this.models.add(clazz);
                System.out.println("Found model: " + clazz.getName());
            }
        }
        catch (Exception e) {
            throw new InstrumentationException(e);
        }
    }

    public List<CtClass> getModels() {
        return this.models;
    }
}

