/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.rest.action.search.RestMultiSearchAction;
import org.elasticsearch.script.mustache.MultiSearchTemplateAction;
import org.elasticsearch.script.mustache.MultiSearchTemplateRequest;
import org.elasticsearch.script.mustache.RestSearchTemplateAction;
import org.elasticsearch.script.mustache.SearchTemplateRequest;

public class RestMultiSearchTemplateAction
extends BaseRestHandler {
    private static final Set<String> RESPONSE_PARAMS = Collections.singleton("typed_keys");
    private final boolean allowExplicitIndex;

    public RestMultiSearchTemplateAction(Settings settings, RestController controller) {
        super(settings);
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_msearch/template", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_msearch/template", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_msearch/template", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_msearch/template", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_msearch/template", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_msearch/template", (RestHandler)this);
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!request.hasContentOrSourceParam()) {
            throw new ElasticsearchException("request body is required", new Object[0]);
        }
        MultiSearchTemplateRequest multiRequest = RestMultiSearchTemplateAction.parseRequest(request, this.allowExplicitIndex);
        return channel -> client.execute((Action)MultiSearchTemplateAction.INSTANCE, (ActionRequest)multiRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public static MultiSearchTemplateRequest parseRequest(RestRequest restRequest, boolean allowExplicitIndex) throws IOException {
        MultiSearchTemplateRequest multiRequest = new MultiSearchTemplateRequest();
        RestMultiSearchAction.parseMultiLineRequest((RestRequest)restRequest, (IndicesOptions)multiRequest.indicesOptions(), (boolean)allowExplicitIndex, (searchRequest, bytes) -> {
            try {
                SearchTemplateRequest searchTemplateRequest = RestSearchTemplateAction.parse(bytes);
                if (searchTemplateRequest.getScript() == null) {
                    throw new IllegalArgumentException("Malformed search template");
                }
                searchTemplateRequest.setRequest((SearchRequest)searchRequest);
                multiRequest.add(searchTemplateRequest);
            }
            catch (IOException e) {
                throw new ElasticsearchParseException("Exception when parsing search template request", (Throwable)e, new Object[0]);
            }
        });
        return multiRequest;
    }

    public boolean supportsContentStream() {
        return true;
    }

    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }
}

