/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.config.datasource.killer.impl;

import com.zaxxer.hikari.HikariDataSource;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.config.datasource.killer.DataSourceKiller;

public final class HikariDataSourceKiller
implements DataSourceKiller {
    public String getType() {
        return "com.zaxxer.hikari.HikariDataSource";
    }

    @Override
    public void closeDataSource(DataSource dataSource) {
        HikariDataSource hikariDataSource = (HikariDataSource)dataSource;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            while (true) {
                if (hikariDataSource.getHikariPoolMXBean().getActiveConnections() == 0) break;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            hikariDataSource.close();
        });
        executor.shutdown();
    }
}

