/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.parser.core;

import java.util.Collection;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.distsql.parser.autogen.EncryptDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.EncryptDistSQLStatementParser;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.encrypt.distsql.parser.segment.EncryptColumnSegment;
import org.apache.shardingsphere.encrypt.distsql.parser.segment.EncryptRuleSegment;
import org.apache.shardingsphere.encrypt.distsql.parser.statement.AlterEncryptRuleStatement;
import org.apache.shardingsphere.encrypt.distsql.parser.statement.CreateEncryptRuleStatement;
import org.apache.shardingsphere.encrypt.distsql.parser.statement.DropEncryptRuleStatement;
import org.apache.shardingsphere.encrypt.distsql.parser.statement.ShowEncryptRulesStatement;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.SchemaSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class EncryptDistSQLStatementVisitor
extends EncryptDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor {
    @Override
    public ASTNode visitCreateEncryptRule(EncryptDistSQLStatementParser.CreateEncryptRuleContext ctx) {
        return new CreateEncryptRuleStatement((Collection)ctx.encryptRuleDefinition().stream().map(each -> (EncryptRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterEncryptRule(EncryptDistSQLStatementParser.AlterEncryptRuleContext ctx) {
        return new AlterEncryptRuleStatement((Collection)ctx.encryptRuleDefinition().stream().map(each -> (EncryptRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDropEncryptRule(EncryptDistSQLStatementParser.DropEncryptRuleContext ctx) {
        return new DropEncryptRuleStatement((Collection)ctx.tableName().stream().map(each -> this.getIdentifierValue((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitShowEncryptRules(EncryptDistSQLStatementParser.ShowEncryptRulesContext ctx) {
        return new ShowEncryptRulesStatement(null == ctx.tableRule() ? null : this.getIdentifierValue((ParseTree)ctx.tableRule().tableName()), null == ctx.schemaName() ? null : (SchemaSegment)this.visit((ParseTree)ctx.schemaName()));
    }

    @Override
    public ASTNode visitEncryptRuleDefinition(EncryptDistSQLStatementParser.EncryptRuleDefinitionContext ctx) {
        return new EncryptRuleSegment(this.getIdentifierValue((ParseTree)ctx.tableName()), (Collection)ctx.columnDefinition().stream().map(each -> (EncryptColumnSegment)this.visit((ParseTree)each)).collect(Collectors.toList()), null == ctx.queryWithCipherColumn() ? null : Boolean.valueOf(Boolean.parseBoolean(this.getIdentifierValue((ParseTree)ctx.queryWithCipherColumn()))));
    }

    @Override
    public ASTNode visitColumnDefinition(EncryptDistSQLStatementParser.ColumnDefinitionContext ctx) {
        return new EncryptColumnSegment(this.getIdentifierValue((ParseTree)ctx.columnName()), this.getIdentifierValue((ParseTree)ctx.cipherColumnName()), null == ctx.plainColumnName() ? null : this.getIdentifierValue((ParseTree)ctx.plainColumnName()), null == ctx.assistedQueryColumnName() ? null : this.getIdentifierValue((ParseTree)ctx.assistedQueryColumnName()), (AlgorithmSegment)this.visit((ParseTree)ctx.algorithmDefinition()));
    }

    @Override
    public ASTNode visitAlgorithmDefinition(EncryptDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(this.getIdentifierValue((ParseTree)ctx.algorithmName()), this.getAlgorithmProperties(ctx));
    }

    private String getIdentifierValue(ParseTree context) {
        if (null == context) {
            return null;
        }
        return new IdentifierValue(context.getText()).getValue();
    }

    private Properties getAlgorithmProperties(EncryptDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx.algorithmProperties()) {
            return result;
        }
        for (EncryptDistSQLStatementParser.AlgorithmPropertyContext each : ctx.algorithmProperties().algorithmProperty()) {
            result.setProperty(new IdentifierValue(each.key.getText()).getValue(), new IdentifierValue(each.value.getText()).getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitTableName(EncryptDistSQLStatementParser.TableNameContext ctx) {
        return new TableNameSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitSchemaName(EncryptDistSQLStatementParser.SchemaNameContext ctx) {
        return new SchemaSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }
}

