/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.reg.zookeeper;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.TransactionOp;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.exception.RegExceptionHandler;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperConfiguration;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZookeeperRegistryCenter
implements CoordinatorRegistryCenter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZookeeperRegistryCenter.class);
    private final ZookeeperConfiguration zkConfig;
    private final Map<String, CuratorCache> caches = new ConcurrentHashMap<String, CuratorCache>();
    private CuratorFramework client;

    public ZookeeperRegistryCenter(ZookeeperConfiguration zkConfig) {
        this.zkConfig = zkConfig;
    }

    @Override
    public void init() {
        log.debug("Elastic job: zookeeper registry center init, server lists is: {}.", (Object)this.zkConfig.getServerLists());
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(this.zkConfig.getServerLists()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(this.zkConfig.getBaseSleepTimeMilliseconds(), this.zkConfig.getMaxRetries(), this.zkConfig.getMaxSleepTimeMilliseconds())).namespace(this.zkConfig.getNamespace());
        if (0 != this.zkConfig.getSessionTimeoutMilliseconds()) {
            builder.sessionTimeoutMs(this.zkConfig.getSessionTimeoutMilliseconds());
        }
        if (0 != this.zkConfig.getConnectionTimeoutMilliseconds()) {
            builder.connectionTimeoutMs(this.zkConfig.getConnectionTimeoutMilliseconds());
        }
        if (!Strings.isNullOrEmpty((String)this.zkConfig.getDigest())) {
            builder.authorization("digest", this.zkConfig.getDigest().getBytes(StandardCharsets.UTF_8)).aclProvider(new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }

                public List<ACL> getAclForPath(String path) {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }
            });
        }
        this.client = builder.build();
        this.client.start();
        try {
            if (!this.client.blockUntilConnected(this.zkConfig.getMaxSleepTimeMilliseconds() * this.zkConfig.getMaxRetries(), TimeUnit.MILLISECONDS)) {
                this.client.close();
                throw new KeeperException.OperationTimeoutException();
            }
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
    }

    @Override
    public void close() {
        for (Map.Entry<String, CuratorCache> each : this.caches.entrySet()) {
            each.getValue().close();
        }
        this.waitForCacheClose();
        CloseableUtils.closeQuietly((Closeable)this.client);
    }

    private void waitForCacheClose() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public String get(String key) {
        CuratorCache cache = this.findCuratorCache(key);
        if (null == cache) {
            return this.getDirectly(key);
        }
        Optional resultInCache = cache.get(key);
        return resultInCache.map(v -> null == v.getData() ? null : new String(v.getData(), StandardCharsets.UTF_8)).orElseGet(() -> this.getDirectly(key));
    }

    private CuratorCache findCuratorCache(String key) {
        for (Map.Entry<String, CuratorCache> entry : this.caches.entrySet()) {
            if (!key.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public String getDirectly(String key) {
        try {
            return new String((byte[])this.client.getData().forPath(key), StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
            return null;
        }
    }

    @Override
    public List<String> getChildrenKeys(String key) {
        try {
            List result = (List)this.client.getChildren().forPath(key);
            result.sort(Comparator.reverseOrder());
            return result;
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
            return Collections.emptyList();
        }
    }

    @Override
    public int getNumChildren(String key) {
        try {
            Stat stat = (Stat)this.client.checkExists().forPath(key);
            if (null != stat) {
                return stat.getNumChildren();
            }
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
        return 0;
    }

    @Override
    public boolean isExisted(String key) {
        try {
            return null != this.client.checkExists().forPath(key);
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
            return false;
        }
    }

    @Override
    public void persist(String key, String value) {
        try {
            if (!this.isExisted(key)) {
                ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
            } else {
                this.update(key, value);
            }
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
    }

    @Override
    public void update(String key, String value) {
        try {
            TransactionOp transactionOp = this.client.transactionOp();
            this.client.transaction().forOperations(new CuratorOp[]{(CuratorOp)transactionOp.check().forPath(key), (CuratorOp)transactionOp.setData().forPath(key, value.getBytes(StandardCharsets.UTF_8))});
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
    }

    @Override
    public void persistEphemeral(String key, String value) {
        try {
            if (this.isExisted(key)) {
                this.client.delete().deletingChildrenIfNeeded().forPath(key);
            }
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
    }

    @Override
    public String persistSequential(String key, String value) {
        try {
            return (String)((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
            return null;
        }
    }

    @Override
    public void persistEphemeralSequential(String key) {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(key);
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
    }

    @Override
    public void remove(String key) {
        try {
            this.client.delete().deletingChildrenIfNeeded().forPath(key);
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
    }

    @Override
    public long getRegistryCenterTime(String key) {
        long result = 0L;
        try {
            this.persist(key, "");
            result = ((Stat)this.client.checkExists().forPath(key)).getMtime();
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
        Preconditions.checkState((0L != result ? 1 : 0) != 0, (Object)"Cannot get registry center time.");
        return result;
    }

    @Override
    public Object getRawClient() {
        return this.client;
    }

    @Override
    public void addCacheData(String cachePath) {
        CuratorCache cache = CuratorCache.build((CuratorFramework)this.client, (String)cachePath, (CuratorCache.Options[])new CuratorCache.Options[0]);
        try {
            cache.start();
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException(ex);
        }
        this.caches.put(cachePath + "/", cache);
    }

    @Override
    public void evictCacheData(String cachePath) {
        CuratorCache cache = this.caches.remove(cachePath + "/");
        if (null != cache) {
            cache.close();
        }
    }

    @Override
    public Object getRawCache(String cachePath) {
        return this.caches.get(cachePath + "/");
    }

    @Generated
    protected ZookeeperConfiguration getZkConfig() {
        return this.zkConfig;
    }

    @Generated
    public CuratorFramework getClient() {
        return this.client;
    }
}

