/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import org.apache.nifi.registry.link.LinkableEntity;

@ApiModel(value="versionedFlowSnapshot")
public class VersionedFlowSnapshotMetadata
extends LinkableEntity
implements Comparable<VersionedFlowSnapshotMetadata> {
    @NotBlank
    private String bucketIdentifier;
    @NotBlank
    private String flowIdentifier;
    @Min(value=1L)
    private @Min(value=1L) int version;
    @Min(value=1L)
    private @Min(value=1L) long timestamp;
    @NotBlank
    private String author;
    private String comments;

    @ApiModelProperty(value="The identifier of the bucket this snapshot belongs to.")
    public String getBucketIdentifier() {
        return this.bucketIdentifier;
    }

    public void setBucketIdentifier(String bucketIdentifier) {
        this.bucketIdentifier = bucketIdentifier;
    }

    @ApiModelProperty(value="The identifier of the flow this snapshot belongs to.")
    public String getFlowIdentifier() {
        return this.flowIdentifier;
    }

    public void setFlowIdentifier(String flowIdentifier) {
        this.flowIdentifier = flowIdentifier;
    }

    @ApiModelProperty(value="The version of this snapshot of the flow.")
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @ApiModelProperty(value="The timestamp when the flow was saved.")
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @ApiModelProperty(value="The user that created this snapshot of the flow.")
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @ApiModelProperty(value="The comments provided by the user when creating the snapshot.")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public int compareTo(VersionedFlowSnapshotMetadata o) {
        return o == null ? -1 : Integer.compare(this.version, o.version);
    }

    public int hashCode() {
        return Objects.hash(this.flowIdentifier, this.version);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionedFlowSnapshotMetadata other = (VersionedFlowSnapshotMetadata)obj;
        return Objects.equals(this.flowIdentifier, other.flowIdentifier) && Objects.equals(this.version, other.version);
    }
}

