/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Locale;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.codec.KeyValueCodecWithTags;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.security.SecureBulkLoadUtil;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HFileTestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestLoadIncrementalHFiles {
    @Rule
    public TestName tn = new TestName();
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"myqual");
    private static final byte[] FAMILY = Bytes.toBytes((String)"myfam");
    private static final String NAMESPACE = "bulkNS";
    static final String EXPECTED_MSG_FOR_NON_EXISTING_FAMILY = "Unmatched family names found";
    static final int MAX_FILES_PER_REGION_PER_FAMILY = 4;
    private static final byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"ppp")};
    static HBaseTestingUtility util = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        util.getConfiguration().set("hbase.coprocessor.region.classes", "");
        util.getConfiguration().setInt("hbase.mapreduce.bulkload.max.hfiles.perRegion.perFamily", 4);
        util.getConfiguration().set("hbase.client.rpc.codec", KeyValueCodecWithTags.class.getCanonicalName());
        util.startMiniCluster();
        TestLoadIncrementalHFiles.setupNamespace();
    }

    protected static void setupNamespace() throws Exception {
        util.getHBaseAdmin().createNamespace(NamespaceDescriptor.create((String)NAMESPACE).build());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    @Test(timeout=120000L)
    public void testSimpleLoad() throws Exception {
        this.runTest("testSimpleLoad", BloomType.NONE, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"cccc")}, new byte[][]{Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"ooo")}}, 2);
    }

    @Test(timeout=120000L)
    public void testRegionCrossingLoad() throws Exception {
        this.runTest("testRegionCrossingLoad", BloomType.NONE, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"eee")}, new byte[][]{Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"zzz")}}, 2);
    }

    @Test(timeout=60000L)
    public void testRegionCrossingRowBloom() throws Exception {
        this.runTest("testRegionCrossingLoadRowBloom", BloomType.ROW, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"eee")}, new byte[][]{Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"zzz")}}, 2);
    }

    @Test(timeout=120000L)
    public void testRegionCrossingRowColBloom() throws Exception {
        this.runTest("testRegionCrossingLoadRowColBloom", BloomType.ROWCOL, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"eee")}, new byte[][]{Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"zzz")}}, 2);
    }

    @Test(timeout=120000L)
    public void testSimpleHFileSplit() throws Exception {
        this.runTest("testHFileSplit", BloomType.NONE, new byte[][]{Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"jjj"), Bytes.toBytes((String)"ppp"), Bytes.toBytes((String)"uuu"), Bytes.toBytes((String)"zzz")}, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"lll")}, new byte[][]{Bytes.toBytes((String)"mmm"), Bytes.toBytes((String)"zzz")}}, 2);
    }

    @Test(timeout=60000L)
    public void testRegionCrossingHFileSplit() throws Exception {
        this.testRegionCrossingHFileSplit(BloomType.NONE);
    }

    @Test(timeout=120000L)
    public void testRegionCrossingHFileSplitRowBloom() throws Exception {
        this.testRegionCrossingHFileSplit(BloomType.ROW);
    }

    @Test(timeout=120000L)
    public void testRegionCrossingHFileSplitRowColBloom() throws Exception {
        this.testRegionCrossingHFileSplit(BloomType.ROWCOL);
    }

    @Test
    public void testSplitALot() throws Exception {
        this.runTest("testSplitALot", BloomType.NONE, new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"ggg"), Bytes.toBytes((String)"hhh"), Bytes.toBytes((String)"iii"), Bytes.toBytes((String)"lll"), Bytes.toBytes((String)"mmm"), Bytes.toBytes((String)"nnn"), Bytes.toBytes((String)"ooo"), Bytes.toBytes((String)"ppp"), Bytes.toBytes((String)"qqq"), Bytes.toBytes((String)"rrr"), Bytes.toBytes((String)"sss"), Bytes.toBytes((String)"ttt"), Bytes.toBytes((String)"uuu"), Bytes.toBytes((String)"vvv"), Bytes.toBytes((String)"zzz")}, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"zzz")}}, 2);
    }

    private void testRegionCrossingHFileSplit(BloomType bloomType) throws Exception {
        this.runTest("testHFileSplit" + bloomType + "Bloom", bloomType, new byte[][]{Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"jjj"), Bytes.toBytes((String)"ppp"), Bytes.toBytes((String)"uuu"), Bytes.toBytes((String)"zzz")}, new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"eee")}, new byte[][]{Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"zzz")}}, 2);
    }

    private HTableDescriptor buildHTD(TableName tableName, BloomType bloomType) {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        HColumnDescriptor familyDesc = new HColumnDescriptor(FAMILY);
        familyDesc.setBloomFilterType(bloomType);
        htd.addFamily(familyDesc);
        return htd;
    }

    private void runTest(String testName, BloomType bloomType, byte[][][] hfileRanges, int depth) throws Exception {
        this.runTest(testName, bloomType, null, hfileRanges, depth);
    }

    private void runTest(String testName, BloomType bloomType, byte[][] tableSplitKeys, byte[][][] hfileRanges, int depth) throws Exception {
        byte[] TABLE_NAME = Bytes.toBytes((String)("mytable_" + testName));
        boolean preCreateTable = tableSplitKeys != null;
        TableName TABLE_WITHOUT_NS = TableName.valueOf((byte[])TABLE_NAME);
        this.runTest(testName, TABLE_WITHOUT_NS, bloomType, preCreateTable, tableSplitKeys, hfileRanges, 2);
        if (preCreateTable) {
            this.runTest(testName + 2, TABLE_WITHOUT_NS, bloomType, true, tableSplitKeys, hfileRanges, 3);
        }
        TableName TABLE_WITH_NS = TableName.valueOf((byte[])Bytes.toBytes((String)NAMESPACE), (byte[])TABLE_NAME);
        this.runTest(testName, TABLE_WITH_NS, bloomType, preCreateTable, tableSplitKeys, hfileRanges, depth);
    }

    private void runTest(String testName, TableName tableName, BloomType bloomType, boolean preCreateTable, byte[][] tableSplitKeys, byte[][][] hfileRanges, int depth) throws Exception {
        HTableDescriptor htd = this.buildHTD(tableName, bloomType);
        this.runTest(testName, htd, bloomType, preCreateTable, tableSplitKeys, hfileRanges, depth);
    }

    private void runTest(String testName, HTableDescriptor htd, BloomType bloomType, boolean preCreateTable, byte[][] tableSplitKeys, byte[][][] hfileRanges, int depth) throws Exception {
        for (boolean managed : new boolean[]{true, false}) {
            Object from;
            Path baseDirectory = util.getDataTestDirOnTestFS(testName);
            FileSystem fs = util.getTestFileSystem();
            Path parentDir = baseDirectory = baseDirectory.makeQualified(fs);
            if (depth == 3) {
                parentDir = new Path(baseDirectory, "someRegion");
            }
            Path familyDir = new Path(parentDir, Bytes.toString((byte[])FAMILY));
            int hfileIdx = 0;
            for (byte[][] range : hfileRanges) {
                from = range[0];
                byte[] to = range[1];
                HFileTestUtil.createHFile(util.getConfiguration(), fs, new Path(familyDir, "hfile_" + hfileIdx++), FAMILY, QUALIFIER, (byte[])from, to, 1000);
            }
            int expectedRows = hfileIdx * 1000;
            if (preCreateTable) {
                util.getHBaseAdmin().createTable(htd, tableSplitKeys);
            }
            TableName tableName = htd.getTableName();
            if (!util.getHBaseAdmin().tableExists(tableName)) {
                util.getHBaseAdmin().createTable(htd);
            }
            LoadIncrementalHFiles loader = new LoadIncrementalHFiles(util.getConfiguration());
            loader.setDepth(depth);
            if (managed) {
                HTable table = new HTable(util.getConfiguration(), tableName);
                from = null;
                try {
                    loader.doBulkLoad(baseDirectory, table);
                    Assert.assertEquals((long)expectedRows, (long)util.countRows((Table)table));
                }
                catch (Throwable x2) {
                    from = x2;
                    throw x2;
                }
                finally {
                    if (table != null) {
                        if (from != null) {
                            try {
                                table.close();
                            }
                            catch (Throwable x2) {
                                ((Throwable)from).addSuppressed(x2);
                            }
                        } else {
                            table.close();
                        }
                    }
                }
            }
            Connection conn = ConnectionFactory.createConnection((Configuration)util.getConfiguration());
            from = null;
            try (HTable table = (HTable)conn.getTable(tableName);){
                loader.doBulkLoad(baseDirectory, table);
            }
            catch (Throwable x2) {
                from = x2;
                throw x2;
            }
            finally {
                if (conn != null) {
                    if (from != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable x2) {
                            ((Throwable)from).addSuppressed(x2);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
            Path stagingBasePath = SecureBulkLoadUtil.getBaseStagingDir((Configuration)util.getConfiguration());
            if (fs.exists(stagingBasePath)) {
                FileStatus[] files;
                for (FileStatus file : files = fs.listStatus(stagingBasePath)) {
                    Assert.assertTrue((String)("Folder=" + file.getPath() + " is not cleaned up."), (file.getPath().getName() != "DONOTERASE" ? 1 : 0) != 0);
                }
            }
            util.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void htestTagsSurviveBulkLoadSplit() throws Exception {
        Path dir = util.getDataTestDirOnTestFS(this.tn.getMethodName());
        FileSystem fs = util.getTestFileSystem();
        dir = dir.makeQualified(fs);
        Path familyDir = new Path(dir, Bytes.toString((byte[])FAMILY));
        byte[][] tableSplitKeys = new byte[][]{Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"jjj"), Bytes.toBytes((String)"ppp"), Bytes.toBytes((String)"uuu"), Bytes.toBytes((String)"zzz")};
        byte[] from = Bytes.toBytes((String)"ddd");
        byte[] to = Bytes.toBytes((String)"ooo");
        HFileTestUtil.createHFileWithTags(util.getConfiguration(), fs, new Path(familyDir, this.tn.getMethodName() + "_hfile"), FAMILY, QUALIFIER, from, to, 1000);
        int expectedRows = 1000;
        TableName tableName = TableName.valueOf((String)this.tn.getMethodName());
        HTableDescriptor htd = this.buildHTD(tableName, BloomType.NONE);
        util.getHBaseAdmin().createTable(htd, (byte[][])tableSplitKeys);
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(util.getConfiguration());
        String[] args = new String[]{dir.toString(), tableName.toString()};
        loader.run(args);
        try (Table table = util.getConnection().getTable(tableName);){
            Assert.assertEquals((long)expectedRows, (long)util.countRows(table));
            HFileTestUtil.verifyTags(table);
        }
        util.deleteTable(tableName);
    }

    @Test(timeout=60000L)
    public void testNonexistentColumnFamilyLoad() throws Exception {
        String testName = "testNonexistentColumnFamilyLoad";
        byte[][][] hFileRanges = new byte[][][]{new byte[][]{Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc")}, new byte[][]{Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"ooo")}};
        byte[] TABLE = Bytes.toBytes((String)("mytable_" + testName));
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])TABLE));
        HColumnDescriptor family = new HColumnDescriptor(Bytes.toBytes((String)new String(FAMILY).toUpperCase(Locale.ROOT)));
        htd.addFamily(family);
        try {
            this.runTest(testName, htd, BloomType.NONE, true, SPLIT_KEYS, (byte[][][])hFileRanges, 2);
            Assert.assertTrue((String)"Loading into table with non-existent family should have failed", (boolean)false);
        }
        catch (Exception e) {
            Assert.assertTrue((String)"IOException expected", (boolean)(e instanceof IOException));
            String errMsg = e.getMessage();
            Assert.assertTrue((String)("Incorrect exception message, expected message: [Unmatched family names found], current message: [" + errMsg + "]"), (boolean)errMsg.contains(EXPECTED_MSG_FOR_NON_EXISTING_FAMILY));
        }
    }

    @Test(timeout=120000L)
    public void testNonHfileFolderWithUnmatchedFamilyName() throws Exception {
        this.testNonHfileFolder("testNonHfileFolderWithUnmatchedFamilyName", true);
    }

    @Test(timeout=120000L)
    public void testNonHfileFolder() throws Exception {
        this.testNonHfileFolder("testNonHfileFolder", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNonHfileFolder(String tableName, boolean preCreateTable) throws Exception {
        Path dir = util.getDataTestDirOnTestFS(tableName);
        FileSystem fs = util.getTestFileSystem();
        dir = dir.makeQualified(fs);
        Path familyDir = new Path(dir, Bytes.toString((byte[])FAMILY));
        HFileTestUtil.createHFile(util.getConfiguration(), fs, new Path(familyDir, "hfile_0"), FAMILY, QUALIFIER, Bytes.toBytes((String)"begin"), Bytes.toBytes((String)"end"), 500);
        TestLoadIncrementalHFiles.createRandomDataFile(fs, new Path(familyDir, "012356789"), 16384);
        String NON_FAMILY_FOLDER = "_logs";
        Path nonFamilyDir = new Path(dir, "_logs");
        fs.mkdirs(nonFamilyDir);
        fs.mkdirs(new Path(nonFamilyDir, "non-file"));
        TestLoadIncrementalHFiles.createRandomDataFile(fs, new Path(nonFamilyDir, "012356789"), 16384);
        Object table = null;
        try {
            table = preCreateTable ? util.createTable(TableName.valueOf((String)tableName), FAMILY) : util.getConnection().getTable(TableName.valueOf((String)tableName));
            String[] args = new String[]{dir.toString(), tableName};
            new LoadIncrementalHFiles(util.getConfiguration()).run(args);
            Assert.assertEquals((long)500L, (long)util.countRows((Table)table));
        }
        finally {
            if (table != null) {
                table.close();
            }
            fs.delete(dir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createRandomDataFile(FileSystem fs, Path path, int size) throws IOException {
        try (FSDataOutputStream stream = fs.create(path);){
            byte[] data = new byte[1024];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(i & 0xFF);
            }
            while (size >= data.length) {
                stream.write(data, 0, data.length);
                size -= data.length;
            }
            if (size > 0) {
                stream.write(data, 0, size);
            }
        }
    }

    @Test(timeout=120000L)
    public void testSplitStoreFile() throws IOException {
        Path dir = util.getDataTestDirOnTestFS("testSplitHFile");
        FileSystem fs = util.getTestFileSystem();
        Path testIn = new Path(dir, "testhfile");
        HColumnDescriptor familyDesc = new HColumnDescriptor(FAMILY);
        HFileTestUtil.createHFile(util.getConfiguration(), fs, testIn, FAMILY, QUALIFIER, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"zzz"), 1000);
        Path bottomOut = new Path(dir, "bottom.out");
        Path topOut = new Path(dir, "top.out");
        LoadIncrementalHFiles.splitStoreFile((Configuration)util.getConfiguration(), (Path)testIn, (HColumnDescriptor)familyDesc, (byte[])Bytes.toBytes((String)"ggg"), (Path)bottomOut, (Path)topOut);
        int rowCount = this.verifyHFile(bottomOut);
        Assert.assertEquals((long)1000L, (long)(rowCount += this.verifyHFile(topOut)));
    }

    @Test
    public void testSplitStoreFileWithNoneToNone() throws IOException {
        this.testSplitStoreFileWithDifferentEncoding(DataBlockEncoding.NONE, DataBlockEncoding.NONE);
    }

    @Test
    public void testSplitStoreFileWithEncodedToEncoded() throws IOException {
        this.testSplitStoreFileWithDifferentEncoding(DataBlockEncoding.DIFF, DataBlockEncoding.DIFF);
    }

    @Test
    public void testSplitStoreFileWithEncodedToNone() throws IOException {
        this.testSplitStoreFileWithDifferentEncoding(DataBlockEncoding.DIFF, DataBlockEncoding.NONE);
    }

    @Test
    public void testSplitStoreFileWithNoneToEncoded() throws IOException {
        this.testSplitStoreFileWithDifferentEncoding(DataBlockEncoding.NONE, DataBlockEncoding.DIFF);
    }

    private void testSplitStoreFileWithDifferentEncoding(DataBlockEncoding bulkloadEncoding, DataBlockEncoding cfEncoding) throws IOException {
        Path dir = util.getDataTestDirOnTestFS("testSplitHFileWithDifferentEncoding");
        FileSystem fs = util.getTestFileSystem();
        Path testIn = new Path(dir, "testhfile");
        HColumnDescriptor familyDesc = new HColumnDescriptor(FAMILY);
        familyDesc.setDataBlockEncoding(cfEncoding);
        HFileTestUtil.createHFileWithDataBlockEncoding(util.getConfiguration(), fs, testIn, bulkloadEncoding, FAMILY, QUALIFIER, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"zzz"), 1000);
        Path bottomOut = new Path(dir, "bottom.out");
        Path topOut = new Path(dir, "top.out");
        LoadIncrementalHFiles.splitStoreFile((Configuration)util.getConfiguration(), (Path)testIn, (HColumnDescriptor)familyDesc, (byte[])Bytes.toBytes((String)"ggg"), (Path)bottomOut, (Path)topOut);
        int rowCount = this.verifyHFile(bottomOut);
        Assert.assertEquals((long)1000L, (long)(rowCount += this.verifyHFile(topOut)));
    }

    private int verifyHFile(Path p) throws IOException {
        Configuration conf = util.getConfiguration();
        HFile.Reader reader = HFile.createReader((FileSystem)p.getFileSystem(conf), (Path)p, (CacheConfig)new CacheConfig(conf), (Configuration)conf);
        reader.loadFileInfo();
        HFileScanner scanner = reader.getScanner(false, false);
        scanner.seekTo();
        int count = 0;
        do {
            ++count;
        } while (scanner.next());
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
        reader.close();
        return count;
    }

    private void addStartEndKeysForTest(TreeMap<byte[], Integer> map, byte[] first, byte[] last) {
        Integer value = map.containsKey(first) ? map.get(first) : 0;
        map.put(first, value + 1);
        value = map.containsKey(last) ? map.get(last) : 0;
        map.put(last, value - 1);
    }

    @Test(timeout=120000L)
    public void testInferBoundaries() {
        TreeMap<byte[], Integer> map = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        String first = "a";
        String last = "e";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "r";
        last = "s";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "o";
        last = "p";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "g";
        last = "k";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "v";
        last = "x";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "c";
        last = "i";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "m";
        last = "q";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "s";
        last = "t";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        first = "u";
        last = "w";
        this.addStartEndKeysForTest(map, first.getBytes(), last.getBytes());
        byte[][] keysArray = LoadIncrementalHFiles.inferBoundaries(map);
        byte[][] compare = new byte[][]{"m".getBytes(), "r".getBytes(), "u".getBytes()};
        Assert.assertEquals((long)keysArray.length, (long)3L);
        for (int row = 0; row < keysArray.length; ++row) {
            Assert.assertArrayEquals((byte[])keysArray[row], (byte[])compare[row]);
        }
    }

    @Test(timeout=60000L)
    public void testLoadTooMayHFiles() throws Exception {
        Path dir = util.getDataTestDirOnTestFS("testLoadTooMayHFiles");
        FileSystem fs = util.getTestFileSystem();
        dir = dir.makeQualified(fs);
        Path familyDir = new Path(dir, Bytes.toString((byte[])FAMILY));
        byte[] from = Bytes.toBytes((String)"begin");
        byte[] to = Bytes.toBytes((String)"end");
        for (int i = 0; i <= 4; ++i) {
            HFileTestUtil.createHFile(util.getConfiguration(), fs, new Path(familyDir, "hfile_" + i), FAMILY, QUALIFIER, from, to, 1000);
        }
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(util.getConfiguration());
        String[] args = new String[]{dir.toString(), "mytable_testLoadTooMayHFiles"};
        try {
            loader.run(args);
            Assert.fail((String)"Bulk loading too many files should fail");
        }
        catch (IOException ie) {
            Assert.assertTrue((boolean)ie.getMessage().contains("Trying to load more than 4 hfiles"));
        }
    }

    @Test(expected=TableNotFoundException.class)
    public void testWithoutAnExistingTableAndCreateTableSetToNo() throws Exception {
        Configuration conf = util.getConfiguration();
        conf.set("create.table", "no");
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(conf);
        String[] args = new String[]{"directory", "nonExistingTable"};
        loader.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testTableWithCFNameStartWithUnderScore() throws Exception {
        Path dir = util.getDataTestDirOnTestFS("cfNameStartWithUnderScore");
        FileSystem fs = util.getTestFileSystem();
        dir = dir.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        String family = "_cf";
        Path familyDir = new Path(dir, family);
        byte[] from = Bytes.toBytes((String)"begin");
        byte[] to = Bytes.toBytes((String)"end");
        Configuration conf = util.getConfiguration();
        String tableName = "mytable_cfNameStartWithUnderScore";
        Table table = util.createTable(TableName.valueOf((String)tableName), family);
        HFileTestUtil.createHFile(conf, fs, new Path(familyDir, "hfile"), Bytes.toBytes((String)family), QUALIFIER, from, to, 1000);
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(conf);
        String[] args = new String[]{dir.toString(), tableName};
        try {
            loader.run(args);
            Assert.assertEquals((long)1000L, (long)util.countRows(table));
        }
        finally {
            if (null != table) {
                table.close();
            }
        }
    }
}

