/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import proguard.classfile.ClassPool;
import proguard.io.DataEntryRewriter;
import proguard.io.DataEntryWriter;

public class ManifestRewriter
extends DataEntryRewriter {
    public ManifestRewriter(ClassPool classPool, DataEntryWriter dataEntryWriter) {
        super(classPool, dataEntryWriter);
    }

    protected void copyData(Reader reader, Writer writer) throws IOException {
        super.copyData(new SplitLineReader(reader), new SplitLineWriter(writer));
    }

    private static class SplitLineWriter
    extends FilterWriter {
        private int counter = 0;

        public SplitLineWriter(Writer writer) {
            super(writer);
        }

        public void write(int c) throws IOException {
            if (c == 10) {
                this.counter = 0;
            } else if (this.counter == 70) {
                super.write(10);
                super.write(32);
                this.counter = 2;
            } else {
                ++this.counter;
            }
            super.write(c);
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int count = 0; count < len; ++count) {
                this.write(cbuf[off + count]);
            }
        }

        public void write(String str, int off, int len) throws IOException {
            this.write(str.toCharArray(), off, len);
        }
    }

    private static class SplitLineReader
    extends FilterReader {
        private static final int NONE = -2;
        private int bufferedCharacter = -2;

        public SplitLineReader(Reader reader) {
            super(reader);
        }

        public int read() throws IOException {
            int c2;
            do {
                int c1 = this.bufferedCharacter != -2 ? this.bufferedCharacter : super.read();
                this.bufferedCharacter = -2;
                if (c1 != 10 && c1 != 13) {
                    return c1;
                }
                c2 = super.read();
                if (c2 != 10 && c2 != 13 || c1 == c2) continue;
                c2 = super.read();
            } while (c2 == 32);
            this.bufferedCharacter = c2;
            return 10;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int c;
            int count = 0;
            while (count < len && (c = this.read()) != -1) {
                cbuf[off + count++] = (char)c;
            }
            return count;
        }

        public long skip(long n) throws IOException {
            int c;
            int count = 0;
            while ((long)count < n && (c = this.read()) != -1) {
                ++count;
            }
            return count;
        }
    }
}

