/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.json;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.dongliu.requests.json.FastJsonProvider;
import net.dongliu.requests.json.GsonProvider;
import net.dongliu.requests.json.JacksonProvider;
import net.dongliu.requests.json.JsonProvider;
import net.dongliu.requests.json.ProviderNotFoundException;

@ThreadSafe
public class JsonLookup {
    private static JsonLookup instance = new JsonLookup();
    @Nullable
    private volatile JsonProvider registeredJsonProvider;
    @Nullable
    private JsonProvider lookedJsonProvider;
    private boolean init;

    private JsonLookup() {
    }

    public static JsonLookup getInstance() {
        return instance;
    }

    public void register(JsonProvider jsonProvider) {
        this.registeredJsonProvider = Objects.requireNonNull(jsonProvider);
    }

    boolean hasGson() {
        try {
            Class.forName("com.google.gson.Gson");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    JsonProvider gsonProvider() {
        return new GsonProvider();
    }

    boolean hasJackson() {
        try {
            Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    boolean hasFastJson() {
        try {
            Class.forName("com.alibaba.fastjson.JSON");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    JsonProvider jacksonProvider() {
        return new JacksonProvider();
    }

    JsonProvider fastJsonProvider() {
        return new FastJsonProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public JsonProvider lookup() {
        if (this.registeredJsonProvider != null) {
            return this.registeredJsonProvider;
        }
        if (!this.init) {
            JsonLookup jsonLookup = this;
            synchronized (jsonLookup) {
                if (!this.init) {
                    this.lookedJsonProvider = this.lookupInClasspath();
                    this.init = true;
                }
            }
        }
        if (this.lookedJsonProvider != null) {
            return this.lookedJsonProvider;
        }
        throw new ProviderNotFoundException("Json Provider not found");
    }

    @Nullable
    private JsonProvider lookupInClasspath() {
        if (this.hasJackson()) {
            return this.jacksonProvider();
        }
        if (this.hasGson()) {
            return this.gsonProvider();
        }
        if (this.hasFastJson()) {
            return this.fastJsonProvider();
        }
        return null;
    }
}

