/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.dongliu.requests.json.AbstractJsonProvider;
import net.dongliu.requests.json.JsonProvider;

public class GsonProvider
extends AbstractJsonProvider
implements JsonProvider {
    private static final Logger logger = Logger.getLogger(GsonProvider.class.getName());
    private final Gson gson;

    public GsonProvider() {
        this(GsonProvider.getDefaultGson());
    }

    private static Gson getDefaultGson() {
        GsonBuilder gsonBuilder = new GsonBuilder().disableHtmlEscaping();
        GsonProvider.registerAllTypeFactories(gsonBuilder);
        return gsonBuilder.create();
    }

    private static void registerAllTypeFactories(GsonBuilder gsonBuilder) {
        ServiceLoader<TypeAdapterFactory> loader = ServiceLoader.load(TypeAdapterFactory.class);
        for (TypeAdapterFactory typeFactory : loader) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Add gson type factory: " + typeFactory.getClass().getName());
            }
            gsonBuilder.registerTypeAdapterFactory(typeFactory);
        }
    }

    public GsonProvider(Gson gson) {
        this.gson = gson;
    }

    @Override
    public void marshal(Writer writer, @Nullable Object value) {
        this.gson.toJson(value, (Appendable)writer);
    }

    @Override
    public <T> T unmarshal(Reader reader, Type type) {
        return (T)this.gson.fromJson(reader, type);
    }
}

